#-------------------------------------------------------------------------------
# SuiteSparse/SPEX/cmake_modules/SPEXConfig.cmake
#-------------------------------------------------------------------------------

# SPEX, Copyright (c) 2019-2024, Chris Lourenco (US Naval Academy), Jinhao Chen
# Lorena Mejia Domenzain, Erick Moreno-Centeno, and Timothy A. Davis, Texas A&M.
# All Rights Reserved.
# SPDX-License-Identifier: GPL-2.0-or-later or LGPL-3.0-or-later

#-------------------------------------------------------------------------------

# Finds the SPEX include file and compiled library.
# The following targets are defined:
#   SuiteSparse::SPEX           - for the shared library (if available)
#   SuiteSparse::SPEX_static    - for the static library (if available)

# For backward compatibility the following variables are set:

# SPEX_INCLUDE_DIR - where to find SPEX.h
# SPEX_LIBRARY     - dynamic SPEX library
# SPEX_STATIC      - static SPEX library
# SPEX_LIBRARIES   - libraries when using SPEX
# SPEX_FOUND       - true if SPEX found

# Set ``CMAKE_MODULE_PATH`` to the parent folder where this module file is
# installed.

#-------------------------------------------------------------------------------


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was SPEXConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/SPEX" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set ( SPEX_DATE "July 25, 2025" )
set ( SPEX_VERSION_MAJOR 3 )
set ( SPEX_VERSION_MINOR 2 )
set ( SPEX_VERSION_PATCH 4 )
set ( SPEX_VERSION "3.2.4" )

# Check for dependent targets
include ( CMakeFindDependencyMacro )

# Look for SuiteSparse_config, AMD and COLAMD targets
if ( OFF )
    if ( NOT TARGET SuiteSparse::SuiteSparseConfig )
        # First check in a common build tree
        find_dependency ( SuiteSparse_config 7.11
            PATHS ${CMAKE_SOURCE_DIR}/../SuiteSparse_config/build NO_DEFAULT_PATH )
        # Then, check in the currently active CMAKE_MODULE_PATH
        if ( NOT SuiteSparse_config_FOUND )
            find_dependency ( SuiteSparse_config 7.11 )
        endif ( )
    endif ( )

    if ( NOT TARGET SuiteSparse::AMD )
        # First check in a common build tree
        find_dependency ( AMD 3.3
            PATHS ${CMAKE_SOURCE_DIR}/../AMD/build NO_DEFAULT_PATH )
        # Then, check in the currently active CMAKE_MODULE_PATH
        if ( NOT AMD_FOUND )
            find_dependency ( AMD 3.3 )
        endif ( )
    endif ( )

    if ( NOT TARGET SuiteSparse::COLAMD )
        # First check in a common build tree
        find_dependency ( COLAMD 3.3
            PATHS ${CMAKE_SOURCE_DIR}/../COLAMD/build NO_DEFAULT_PATH )
        # Then, check in the currently active CMAKE_MODULE_PATH
        if ( NOT COLAMD_FOUND )
            find_dependency ( COLAMD 3.3 )
        endif ( )
    endif ( )

else ( )
    if ( NOT TARGET SuiteSparse::SuiteSparseConfig )
        find_dependency ( SuiteSparse_config 7.11 )
    endif ( )
    if ( NOT TARGET SuiteSparse::AMD )
        find_dependency ( AMD 3.3 )
    endif ( )
    if ( NOT TARGET SuiteSparse::COLAMD )
        find_dependency ( COLAMD 3.3 )
    endif ( )
endif ( )

# Look for GMP and MPFR modules
list ( PREPEND CMAKE_MODULE_PATH ${CMAKE_CURRENT_LIST_DIR} )
if ( NOT GMP_FOUND )
    find_dependency ( GMP 6.1.2 )
endif ( )
if ( NOT MPFR_FOUND )
    find_dependency ( MPFR 4.0.2 )
endif ( )

if ( NOT SuiteSparse_config_FOUND OR NOT AMD_FOUND OR NOT COLAMD_FOUND
        OR NOT GMP_FOUND OR NOT MPFR_FOUND)
    set ( SPEX_FOUND OFF )
    return ( )
endif ( )


# Import target
if ( ON )
    include ( ${CMAKE_CURRENT_LIST_DIR}/SPEXTargets.cmake )
endif ( )
if ( ON )
    include ( ${CMAKE_CURRENT_LIST_DIR}/SPEXTargets_static.cmake )
endif ( )

# The following is only for backward compatibility with FindSPEX.

set ( _target_shared SuiteSparse::SPEX )
set ( _target_static SuiteSparse::SPEX_static )
set ( _var_prefix "SPEX" )

if ( NOT ON AND NOT TARGET ${_target_shared} )
    # make sure there is always an import target without suffix )
    add_library ( ${_target_shared} ALIAS ${_target_static} )
endif ( )

get_target_property ( ${_var_prefix}_INCLUDE_DIR ${_target_shared} INTERFACE_INCLUDE_DIRECTORIES )
if ( ${_var_prefix}_INCLUDE_DIR )
    # First item in SuiteSparse targets contains the "main" header directory.
    list ( GET ${_var_prefix}_INCLUDE_DIR 0 ${_var_prefix}_INCLUDE_DIR )
endif ( )
get_target_property ( ${_var_prefix}_LIBRARY ${_target_shared} IMPORTED_IMPLIB )
if ( NOT ${_var_prefix}_LIBRARY )
    get_target_property ( _library_chk ${_target_shared} IMPORTED_LOCATION )
    if ( EXISTS ${_library_chk} )
        set ( ${_var_prefix}_LIBRARY ${_library_chk} )
    endif ( )
endif ( )
if ( TARGET ${_target_static} )
    get_target_property ( ${_var_prefix}_STATIC ${_target_static} IMPORTED_LOCATION )
endif ( )

# Check for most common build types
set ( _config_types "Debug" "Release" "RelWithDebInfo" "MinSizeRel" "None" )

get_property ( _isMultiConfig GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG )
if ( _isMultiConfig )
    # For multi-configuration generators (e.g., Visual Studio), prefer those
    # configurations.
    list ( PREPEND _config_types ${CMAKE_CONFIGURATION_TYPES} )
else ( )
    # For single-configuration generators, prefer the current configuration.
    list ( PREPEND _config_types ${CMAKE_BUILD_TYPE} )
endif ( )

list ( REMOVE_DUPLICATES _config_types )

foreach ( _config ${_config_types} )
    string ( TOUPPER ${_config} _uc_config )
    if ( NOT ${_var_prefix}_LIBRARY )
        get_target_property ( _library_chk ${_target_shared}
            IMPORTED_IMPLIB_${_uc_config} )
        if ( EXISTS ${_library_chk} )
            set ( ${_var_prefix}_LIBRARY ${_library_chk} )
        endif ( )
    endif ( )
    if ( NOT ${_var_prefix}_LIBRARY )
        get_target_property ( _library_chk ${_target_shared}
            IMPORTED_LOCATION_${_uc_config} )
        if ( EXISTS ${_library_chk} )
            set ( ${_var_prefix}_LIBRARY ${_library_chk} )
        endif ( )
    endif ( )
    if ( TARGET ${_target_static} AND NOT ${_var_prefix}_STATIC )
        get_target_property ( _library_chk ${_target_static}
            IMPORTED_LOCATION_${_uc_config} )
        if ( EXISTS ${_library_chk} )
            set ( ${_var_prefix}_STATIC ${_library_chk} )
        endif ( )
    endif ( )
endforeach ( )

set ( SPEX_LIBRARIES ${SPEX_LIBRARY} )

macro ( suitesparse_check_exist _var _files )
  # ignore generator expressions
  string ( GENEX_STRIP "${_files}" _files2 )

  foreach ( _file ${_files2} )
    if ( NOT EXISTS "${_file}" )
      message ( FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist!" )
    endif ( )
  endforeach ()
endmacro ( )

suitesparse_check_exist ( SPEX_INCLUDE_DIR ${SPEX_INCLUDE_DIR} )
suitesparse_check_exist ( SPEX_LIBRARY ${SPEX_LIBRARY} )

message ( STATUS "SPEX version: ${SPEX_VERSION}" )
message ( STATUS "SPEX include: ${SPEX_INCLUDE_DIR}" )
message ( STATUS "SPEX library: ${SPEX_LIBRARY}" )
message ( STATUS "SPEX static:  ${SPEX_STATIC}" )
