
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2012 Lanedo GmbH
 * Copyright (C) 2012-2022 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include "qmi-enums.h"
#include "qmi-enums-pdc.h"
#include "qmi-message.h"
#include "qmi-client.h"

#ifndef __LIBQMI_GLIB_QMI_PDC__
#define __LIBQMI_GLIB_QMI_PDC__

G_BEGIN_DECLS

#define HAVE_QMI_MESSAGE_PDC_REGISTER
#define HAVE_QMI_MESSAGE_PDC_GET_SELECTED_CONFIG
#define HAVE_QMI_MESSAGE_PDC_SET_SELECTED_CONFIG
#define HAVE_QMI_MESSAGE_PDC_LIST_CONFIGS
#define HAVE_QMI_MESSAGE_PDC_ACTIVATE_CONFIG
#define HAVE_QMI_MESSAGE_PDC_GET_CONFIG_INFO
#define HAVE_QMI_INDICATION_PDC_GET_SELECTED_CONFIG
#define HAVE_QMI_INDICATION_PDC_SET_SELECTED_CONFIG
#define HAVE_QMI_INDICATION_PDC_LIST_CONFIGS
#define HAVE_QMI_INDICATION_PDC_ACTIVATE_CONFIG
#define HAVE_QMI_INDICATION_PDC_GET_CONFIG_INFO
#define HAVE_QMI_INDICATION_PDC_REFRESH

/* messages unsupported in collection */
/* HAVE_QMI_MESSAGE_PDC_RESET */
/* HAVE_QMI_MESSAGE_PDC_CONFIG_CHANGE */
/* HAVE_QMI_MESSAGE_PDC_DELETE_CONFIG */
/* HAVE_QMI_MESSAGE_PDC_LOAD_CONFIG */
/* HAVE_QMI_INDICATION_PDC_LOAD_CONFIG */
/* HAVE_QMI_MESSAGE_PDC_GET_CONFIG_LIMITS */
/* HAVE_QMI_MESSAGE_PDC_GET_DEFAULT_CONFIG_INFO */
/* HAVE_QMI_MESSAGE_PDC_DEACTIVATE_CONFIG */
/* HAVE_QMI_INDICATION_PDC_DEACTIVATE_CONFIG */

/*****************************************************************************/
/* INDICATION: Qmi Indication PDC Get Selected Config */


/**
 * SECTION: qmi-indication-pdc-get-selected-config
 * @title: PDC Get Selected Config indication
 * @short_description: Methods to manage the PDC Get Selected Config indication.
 *
 * Collection of methods to parse indications of the PDC Get Selected Config message.
 */

/* --- Output -- */

/**
 * QmiIndicationPdcGetSelectedConfigOutput:
 *
 * The #QmiIndicationPdcGetSelectedConfigOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiIndicationPdcGetSelectedConfigOutput QmiIndicationPdcGetSelectedConfigOutput;
GType qmi_indication_pdc_get_selected_config_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_INDICATION_PDC_GET_SELECTED_CONFIG_OUTPUT (qmi_indication_pdc_get_selected_config_output_get_type ())


/**
 * qmi_indication_pdc_get_selected_config_output_get_pending_id:
 * @self: a #QmiIndicationPdcGetSelectedConfigOutput.
 * @value_pending_id: (out)(optional)(element-type guint8)(transfer none): a placeholder for the output #GArray of #guint8 elements, or %NULL if not required. Do not free it, it is owned by @self.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Pending Id' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_selected_config_output_get_pending_id (
    QmiIndicationPdcGetSelectedConfigOutput *self,
    GArray **value_pending_id,
    GError **error);


/**
 * qmi_indication_pdc_get_selected_config_output_get_active_id:
 * @self: a #QmiIndicationPdcGetSelectedConfigOutput.
 * @value_active_id: (out)(optional)(element-type guint8)(transfer none): a placeholder for the output #GArray of #guint8 elements, or %NULL if not required. Do not free it, it is owned by @self.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Active Id' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_selected_config_output_get_active_id (
    QmiIndicationPdcGetSelectedConfigOutput *self,
    GArray **value_active_id,
    GError **error);


/**
 * qmi_indication_pdc_get_selected_config_output_get_indication_result:
 * @self: a #QmiIndicationPdcGetSelectedConfigOutput.
 * @value_indication_result: (out)(optional): a placeholder for the output #guint16, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Indication Result' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_selected_config_output_get_indication_result (
    QmiIndicationPdcGetSelectedConfigOutput *self,
    guint16 *value_indication_result,
    GError **error);


/**
 * qmi_indication_pdc_get_selected_config_output_get_token:
 * @self: a #QmiIndicationPdcGetSelectedConfigOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_selected_config_output_get_token (
    QmiIndicationPdcGetSelectedConfigOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_indication_pdc_get_selected_config_output_ref:
 * @self: a #QmiIndicationPdcGetSelectedConfigOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiIndicationPdcGetSelectedConfigOutput *qmi_indication_pdc_get_selected_config_output_ref (QmiIndicationPdcGetSelectedConfigOutput *self);

/**
 * qmi_indication_pdc_get_selected_config_output_unref:
 * @self: a #QmiIndicationPdcGetSelectedConfigOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_indication_pdc_get_selected_config_output_unref (QmiIndicationPdcGetSelectedConfigOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiIndicationPdcGetSelectedConfigOutput, qmi_indication_pdc_get_selected_config_output_unref)

/**
 * qmi_indication_pdc_get_selected_config_indication_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiIndicationPdcGetSelectedConfigOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiIndicationPdcGetSelectedConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_indication_pdc_get_selected_config_output_unref().
 *
 * Since: 1.34
 */
QmiIndicationPdcGetSelectedConfigOutput *qmi_indication_pdc_get_selected_config_indication_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* INDICATION: Qmi Indication PDC Set Selected Config */


/**
 * SECTION: qmi-indication-pdc-set-selected-config
 * @title: PDC Set Selected Config indication
 * @short_description: Methods to manage the PDC Set Selected Config indication.
 *
 * Collection of methods to parse indications of the PDC Set Selected Config message.
 */

/* --- Output -- */

/**
 * QmiIndicationPdcSetSelectedConfigOutput:
 *
 * The #QmiIndicationPdcSetSelectedConfigOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiIndicationPdcSetSelectedConfigOutput QmiIndicationPdcSetSelectedConfigOutput;
GType qmi_indication_pdc_set_selected_config_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_INDICATION_PDC_SET_SELECTED_CONFIG_OUTPUT (qmi_indication_pdc_set_selected_config_output_get_type ())


/**
 * qmi_indication_pdc_set_selected_config_output_get_token:
 * @self: a #QmiIndicationPdcSetSelectedConfigOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_set_selected_config_output_get_token (
    QmiIndicationPdcSetSelectedConfigOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_indication_pdc_set_selected_config_output_get_indication_result:
 * @self: a #QmiIndicationPdcSetSelectedConfigOutput.
 * @value_indication_result: (out)(optional): a placeholder for the output #guint16, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Indication Result' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_set_selected_config_output_get_indication_result (
    QmiIndicationPdcSetSelectedConfigOutput *self,
    guint16 *value_indication_result,
    GError **error);


/**
 * qmi_indication_pdc_set_selected_config_output_ref:
 * @self: a #QmiIndicationPdcSetSelectedConfigOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiIndicationPdcSetSelectedConfigOutput *qmi_indication_pdc_set_selected_config_output_ref (QmiIndicationPdcSetSelectedConfigOutput *self);

/**
 * qmi_indication_pdc_set_selected_config_output_unref:
 * @self: a #QmiIndicationPdcSetSelectedConfigOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_indication_pdc_set_selected_config_output_unref (QmiIndicationPdcSetSelectedConfigOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiIndicationPdcSetSelectedConfigOutput, qmi_indication_pdc_set_selected_config_output_unref)

/**
 * qmi_indication_pdc_set_selected_config_indication_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiIndicationPdcSetSelectedConfigOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiIndicationPdcSetSelectedConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_indication_pdc_set_selected_config_output_unref().
 *
 * Since: 1.34
 */
QmiIndicationPdcSetSelectedConfigOutput *qmi_indication_pdc_set_selected_config_indication_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* INDICATION: Qmi Indication PDC List Configs */


/**
 * SECTION: qmi-indication-pdc-list-configs
 * @title: PDC List Configs indication
 * @short_description: Methods to manage the PDC List Configs indication.
 *
 * Collection of methods to parse indications of the PDC List Configs message.
 */

/* --- Output -- */


/**
 * QmiIndicationPdcListConfigsOutputConfigsElement:
 * @config_type: a #QmiPdcConfigurationType.
 * @id: a #GArray of #guint8 elements.
 *
 * A QmiIndicationPdcListConfigsOutputConfigsElement struct.
 *
 * Since: 1.18
 */
typedef struct _QmiIndicationPdcListConfigsOutputConfigsElement {
    QmiPdcConfigurationType config_type;
    GArray *id;
} QmiIndicationPdcListConfigsOutputConfigsElement;

GType qmi_indication_pdc_list_configs_output_configs_element_get_type (void) G_GNUC_CONST;

/**
 * QmiIndicationPdcListConfigsOutput:
 *
 * The #QmiIndicationPdcListConfigsOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiIndicationPdcListConfigsOutput QmiIndicationPdcListConfigsOutput;
GType qmi_indication_pdc_list_configs_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_INDICATION_PDC_LIST_CONFIGS_OUTPUT (qmi_indication_pdc_list_configs_output_get_type ())


/**
 * qmi_indication_pdc_list_configs_output_get_configs: (skip)
 * @self: a #QmiIndicationPdcListConfigsOutput.
 * @value_configs: (out)(optional)(element-type QmiIndicationPdcListConfigsOutputConfigsElement)(transfer none): a placeholder for the output #GArray of #QmiIndicationPdcListConfigsOutputConfigsElement elements, or %NULL if not required. Do not free it, it is owned by @self.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Configs' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_list_configs_output_get_configs (
    QmiIndicationPdcListConfigsOutput *self,
    GArray **value_configs,
    GError **error);


/**
 * qmi_indication_pdc_list_configs_output_get_configs_gir: (rename-to qmi_indication_pdc_list_configs_output_get_configs)
 * @self: a #QmiIndicationPdcListConfigsOutput.
 * @value_configs_ptr: (out)(optional)(element-type QmiIndicationPdcListConfigsOutputConfigsElement)(transfer none): a placeholder for the output array of #QmiIndicationPdcListConfigsOutputConfigsElement elements, or %NULL if not required. Do not free or modify it, it is owned by @self.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Configs' field from @self.
 *
 * Version of qmi_indication_pdc_list_configs_output_get_configs() using arrays of pointers to
 * structs instead of arrays of structs, for easier binding in other languages.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_indication_pdc_list_configs_output_get_configs_gir (
    QmiIndicationPdcListConfigsOutput *self,
    GPtrArray **value_configs_ptr,
    GError **error);


/**
 * qmi_indication_pdc_list_configs_output_get_indication_result:
 * @self: a #QmiIndicationPdcListConfigsOutput.
 * @value_indication_result: (out)(optional): a placeholder for the output #guint16, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Indication Result' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_list_configs_output_get_indication_result (
    QmiIndicationPdcListConfigsOutput *self,
    guint16 *value_indication_result,
    GError **error);


/**
 * qmi_indication_pdc_list_configs_output_get_token:
 * @self: a #QmiIndicationPdcListConfigsOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_list_configs_output_get_token (
    QmiIndicationPdcListConfigsOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_indication_pdc_list_configs_output_ref:
 * @self: a #QmiIndicationPdcListConfigsOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiIndicationPdcListConfigsOutput *qmi_indication_pdc_list_configs_output_ref (QmiIndicationPdcListConfigsOutput *self);

/**
 * qmi_indication_pdc_list_configs_output_unref:
 * @self: a #QmiIndicationPdcListConfigsOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_indication_pdc_list_configs_output_unref (QmiIndicationPdcListConfigsOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiIndicationPdcListConfigsOutput, qmi_indication_pdc_list_configs_output_unref)

/**
 * qmi_indication_pdc_list_configs_indication_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiIndicationPdcListConfigsOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiIndicationPdcListConfigsOutput, or %NULL if @error is set. The returned value should be freed with qmi_indication_pdc_list_configs_output_unref().
 *
 * Since: 1.34
 */
QmiIndicationPdcListConfigsOutput *qmi_indication_pdc_list_configs_indication_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* INDICATION: Qmi Indication PDC Activate Config */


/**
 * SECTION: qmi-indication-pdc-activate-config
 * @title: PDC Activate Config indication
 * @short_description: Methods to manage the PDC Activate Config indication.
 *
 * Collection of methods to parse indications of the PDC Activate Config message.
 */

/* --- Output -- */

/**
 * QmiIndicationPdcActivateConfigOutput:
 *
 * The #QmiIndicationPdcActivateConfigOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiIndicationPdcActivateConfigOutput QmiIndicationPdcActivateConfigOutput;
GType qmi_indication_pdc_activate_config_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_INDICATION_PDC_ACTIVATE_CONFIG_OUTPUT (qmi_indication_pdc_activate_config_output_get_type ())


/**
 * qmi_indication_pdc_activate_config_output_get_token:
 * @self: a #QmiIndicationPdcActivateConfigOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_activate_config_output_get_token (
    QmiIndicationPdcActivateConfigOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_indication_pdc_activate_config_output_get_indication_result:
 * @self: a #QmiIndicationPdcActivateConfigOutput.
 * @value_indication_result: (out)(optional): a placeholder for the output #guint16, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Indication Result' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_activate_config_output_get_indication_result (
    QmiIndicationPdcActivateConfigOutput *self,
    guint16 *value_indication_result,
    GError **error);


/**
 * qmi_indication_pdc_activate_config_output_ref:
 * @self: a #QmiIndicationPdcActivateConfigOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiIndicationPdcActivateConfigOutput *qmi_indication_pdc_activate_config_output_ref (QmiIndicationPdcActivateConfigOutput *self);

/**
 * qmi_indication_pdc_activate_config_output_unref:
 * @self: a #QmiIndicationPdcActivateConfigOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_indication_pdc_activate_config_output_unref (QmiIndicationPdcActivateConfigOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiIndicationPdcActivateConfigOutput, qmi_indication_pdc_activate_config_output_unref)

/**
 * qmi_indication_pdc_activate_config_indication_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiIndicationPdcActivateConfigOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiIndicationPdcActivateConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_indication_pdc_activate_config_output_unref().
 *
 * Since: 1.34
 */
QmiIndicationPdcActivateConfigOutput *qmi_indication_pdc_activate_config_indication_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* INDICATION: Qmi Indication PDC Get Config Info */


/**
 * SECTION: qmi-indication-pdc-get-config-info
 * @title: PDC Get Config Info indication
 * @short_description: Methods to manage the PDC Get Config Info indication.
 *
 * Collection of methods to parse indications of the PDC Get Config Info message.
 */

/* --- Output -- */

/**
 * QmiIndicationPdcGetConfigInfoOutput:
 *
 * The #QmiIndicationPdcGetConfigInfoOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiIndicationPdcGetConfigInfoOutput QmiIndicationPdcGetConfigInfoOutput;
GType qmi_indication_pdc_get_config_info_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_INDICATION_PDC_GET_CONFIG_INFO_OUTPUT (qmi_indication_pdc_get_config_info_output_get_type ())


/**
 * qmi_indication_pdc_get_config_info_output_get_version:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 * @value_version: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Version' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_config_info_output_get_version (
    QmiIndicationPdcGetConfigInfoOutput *self,
    guint32 *value_version,
    GError **error);


/**
 * qmi_indication_pdc_get_config_info_output_get_description:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 * @value_description: (out)(optional)(transfer none): a placeholder for the output constant string, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Description' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_config_info_output_get_description (
    QmiIndicationPdcGetConfigInfoOutput *self,
    const gchar **value_description,
    GError **error);


/**
 * qmi_indication_pdc_get_config_info_output_get_total_size:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 * @value_total_size: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Total Size' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_config_info_output_get_total_size (
    QmiIndicationPdcGetConfigInfoOutput *self,
    guint32 *value_total_size,
    GError **error);


/**
 * qmi_indication_pdc_get_config_info_output_get_indication_result:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 * @value_indication_result: (out)(optional): a placeholder for the output #guint16, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Indication Result' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_config_info_output_get_indication_result (
    QmiIndicationPdcGetConfigInfoOutput *self,
    guint16 *value_indication_result,
    GError **error);


/**
 * qmi_indication_pdc_get_config_info_output_get_token:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_indication_pdc_get_config_info_output_get_token (
    QmiIndicationPdcGetConfigInfoOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_indication_pdc_get_config_info_output_ref:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiIndicationPdcGetConfigInfoOutput *qmi_indication_pdc_get_config_info_output_ref (QmiIndicationPdcGetConfigInfoOutput *self);

/**
 * qmi_indication_pdc_get_config_info_output_unref:
 * @self: a #QmiIndicationPdcGetConfigInfoOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_indication_pdc_get_config_info_output_unref (QmiIndicationPdcGetConfigInfoOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiIndicationPdcGetConfigInfoOutput, qmi_indication_pdc_get_config_info_output_unref)

/**
 * qmi_indication_pdc_get_config_info_indication_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiIndicationPdcGetConfigInfoOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiIndicationPdcGetConfigInfoOutput, or %NULL if @error is set. The returned value should be freed with qmi_indication_pdc_get_config_info_output_unref().
 *
 * Since: 1.34
 */
QmiIndicationPdcGetConfigInfoOutput *qmi_indication_pdc_get_config_info_indication_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* INDICATION: Qmi Indication PDC Refresh */


/**
 * SECTION: qmi-indication-pdc-refresh
 * @title: PDC Refresh indication
 * @short_description: Methods to manage the PDC Refresh indication.
 *
 * Collection of methods to parse indications of the PDC Refresh message.
 */

/* --- Output -- */

/**
 * QmiIndicationPdcRefreshOutput:
 *
 * The #QmiIndicationPdcRefreshOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.32
 */
typedef struct _QmiIndicationPdcRefreshOutput QmiIndicationPdcRefreshOutput;
GType qmi_indication_pdc_refresh_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_INDICATION_PDC_REFRESH_OUTPUT (qmi_indication_pdc_refresh_output_get_type ())


/**
 * qmi_indication_pdc_refresh_output_get_slot_id:
 * @self: a #QmiIndicationPdcRefreshOutput.
 * @value_slot_id: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Slot ID' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_indication_pdc_refresh_output_get_slot_id (
    QmiIndicationPdcRefreshOutput *self,
    guint32 *value_slot_id,
    GError **error);


/**
 * qmi_indication_pdc_refresh_output_get_subscription_id:
 * @self: a #QmiIndicationPdcRefreshOutput.
 * @value_subscription_id: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Subscription ID' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_indication_pdc_refresh_output_get_subscription_id (
    QmiIndicationPdcRefreshOutput *self,
    guint32 *value_subscription_id,
    GError **error);


/**
 * qmi_indication_pdc_refresh_output_get_refresh_event:
 * @self: a #QmiIndicationPdcRefreshOutput.
 * @value_refresh_event: (out)(optional): a placeholder for the output #QmiPdcRefreshEventType, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Refresh Event' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_indication_pdc_refresh_output_get_refresh_event (
    QmiIndicationPdcRefreshOutput *self,
    QmiPdcRefreshEventType *value_refresh_event,
    GError **error);


/**
 * qmi_indication_pdc_refresh_output_ref:
 * @self: a #QmiIndicationPdcRefreshOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.32
 */
QmiIndicationPdcRefreshOutput *qmi_indication_pdc_refresh_output_ref (QmiIndicationPdcRefreshOutput *self);

/**
 * qmi_indication_pdc_refresh_output_unref:
 * @self: a #QmiIndicationPdcRefreshOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.32
 */
void qmi_indication_pdc_refresh_output_unref (QmiIndicationPdcRefreshOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiIndicationPdcRefreshOutput, qmi_indication_pdc_refresh_output_unref)

/**
 * qmi_indication_pdc_refresh_indication_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiIndicationPdcRefreshOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiIndicationPdcRefreshOutput, or %NULL if @error is set. The returned value should be freed with qmi_indication_pdc_refresh_output_unref().
 *
 * Since: 1.34
 */
QmiIndicationPdcRefreshOutput *qmi_indication_pdc_refresh_indication_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message PDC Register */


/**
 * SECTION: qmi-message-pdc-register
 * @title: PDC Register response
 * @short_description: Methods to manage the PDC Register response.
 *
 * Collection of methods to create requests and parse responses of the PDC Register message.
 */

/* --- Input -- */

/**
 * QmiMessagePdcRegisterInput:
 *
 * The #QmiMessagePdcRegisterInput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcRegisterInput QmiMessagePdcRegisterInput;
GType qmi_message_pdc_register_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_REGISTER_INPUT (qmi_message_pdc_register_input_get_type ())


/**
 * qmi_message_pdc_register_input_get_enable_refresh:
 * @self: a #QmiMessagePdcRegisterInput.
 * @value_enable_refresh: (out)(optional): a placeholder for the output #gboolean, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Enable Refresh' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_message_pdc_register_input_get_enable_refresh (
    QmiMessagePdcRegisterInput *self,
    gboolean *value_enable_refresh,
    GError **error);


/**
 * qmi_message_pdc_register_input_set_enable_refresh:
 * @self: a #QmiMessagePdcRegisterInput.
 * @value_enable_refresh: a #gboolean.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Enable Refresh' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_message_pdc_register_input_set_enable_refresh (
    QmiMessagePdcRegisterInput *self,
    gboolean value_enable_refresh,
    GError **error);


/**
 * qmi_message_pdc_register_input_get_enable_reporting:
 * @self: a #QmiMessagePdcRegisterInput.
 * @value_enable_reporting: (out)(optional): a placeholder for the output #gboolean, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Enable Reporting' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_register_input_get_enable_reporting (
    QmiMessagePdcRegisterInput *self,
    gboolean *value_enable_reporting,
    GError **error);


/**
 * qmi_message_pdc_register_input_set_enable_reporting:
 * @self: a #QmiMessagePdcRegisterInput.
 * @value_enable_reporting: a #gboolean.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Enable Reporting' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_register_input_set_enable_reporting (
    QmiMessagePdcRegisterInput *self,
    gboolean value_enable_reporting,
    GError **error);


/**
 * qmi_message_pdc_register_input_ref:
 * @self: a #QmiMessagePdcRegisterInput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcRegisterInput *qmi_message_pdc_register_input_ref (QmiMessagePdcRegisterInput *self);

/**
 * qmi_message_pdc_register_input_unref:
 * @self: a #QmiMessagePdcRegisterInput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_register_input_unref (QmiMessagePdcRegisterInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcRegisterInput, qmi_message_pdc_register_input_unref)

/**
 * qmi_message_pdc_register_input_new:
 *
 * Allocates a new #QmiMessagePdcRegisterInput.
 *
 * Returns: the newly created #QmiMessagePdcRegisterInput. The returned value should be freed with qmi_message_pdc_register_input_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcRegisterInput *qmi_message_pdc_register_input_new (void);

/* --- Output -- */

/**
 * QmiMessagePdcRegisterOutput:
 *
 * The #QmiMessagePdcRegisterOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcRegisterOutput QmiMessagePdcRegisterOutput;
GType qmi_message_pdc_register_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_REGISTER_OUTPUT (qmi_message_pdc_register_output_get_type ())


/**
 * qmi_message_pdc_register_output_get_result:
 * @self: a QmiMessagePdcRegisterOutput.
 * @error: Return location for error or %NULL.
 *
 * Get the result of the QMI operation.
 *
 * Returns: (skip): %TRUE if the QMI operation succeeded, %FALSE if @error is set.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_register_output_get_result (
    QmiMessagePdcRegisterOutput *self,
    GError **error);


/**
 * qmi_message_pdc_register_output_ref:
 * @self: a #QmiMessagePdcRegisterOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcRegisterOutput *qmi_message_pdc_register_output_ref (QmiMessagePdcRegisterOutput *self);

/**
 * qmi_message_pdc_register_output_unref:
 * @self: a #QmiMessagePdcRegisterOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_register_output_unref (QmiMessagePdcRegisterOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcRegisterOutput, qmi_message_pdc_register_output_unref)

/**
 * qmi_message_pdc_register_response_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiMessagePdcRegisterOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiMessagePdcRegisterOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_register_output_unref().
 *
 * Since: 1.34
 */
QmiMessagePdcRegisterOutput *qmi_message_pdc_register_response_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message PDC Get Selected Config */


/**
 * SECTION: qmi-message-pdc-get-selected-config
 * @title: PDC Get Selected Config response
 * @short_description: Methods to manage the PDC Get Selected Config response.
 *
 * Collection of methods to create requests and parse responses of the PDC Get Selected Config message.
 */

/* --- Input -- */

/**
 * QmiMessagePdcGetSelectedConfigInput:
 *
 * The #QmiMessagePdcGetSelectedConfigInput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcGetSelectedConfigInput QmiMessagePdcGetSelectedConfigInput;
GType qmi_message_pdc_get_selected_config_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_GET_SELECTED_CONFIG_INPUT (qmi_message_pdc_get_selected_config_input_get_type ())


/**
 * qmi_message_pdc_get_selected_config_input_get_token:
 * @self: a #QmiMessagePdcGetSelectedConfigInput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_selected_config_input_get_token (
    QmiMessagePdcGetSelectedConfigInput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_get_selected_config_input_set_token:
 * @self: a #QmiMessagePdcGetSelectedConfigInput.
 * @value_token: a #guint32.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Token' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_selected_config_input_set_token (
    QmiMessagePdcGetSelectedConfigInput *self,
    guint32 value_token,
    GError **error);


/**
 * qmi_message_pdc_get_selected_config_input_get_config_type:
 * @self: a #QmiMessagePdcGetSelectedConfigInput.
 * @value_config_type: (out)(optional): a placeholder for the output #QmiPdcConfigurationType, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Config Type' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_selected_config_input_get_config_type (
    QmiMessagePdcGetSelectedConfigInput *self,
    QmiPdcConfigurationType *value_config_type,
    GError **error);


/**
 * qmi_message_pdc_get_selected_config_input_set_config_type:
 * @self: a #QmiMessagePdcGetSelectedConfigInput.
 * @value_config_type: a #QmiPdcConfigurationType.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Config Type' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_selected_config_input_set_config_type (
    QmiMessagePdcGetSelectedConfigInput *self,
    QmiPdcConfigurationType value_config_type,
    GError **error);


/**
 * qmi_message_pdc_get_selected_config_input_ref:
 * @self: a #QmiMessagePdcGetSelectedConfigInput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcGetSelectedConfigInput *qmi_message_pdc_get_selected_config_input_ref (QmiMessagePdcGetSelectedConfigInput *self);

/**
 * qmi_message_pdc_get_selected_config_input_unref:
 * @self: a #QmiMessagePdcGetSelectedConfigInput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_get_selected_config_input_unref (QmiMessagePdcGetSelectedConfigInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcGetSelectedConfigInput, qmi_message_pdc_get_selected_config_input_unref)

/**
 * qmi_message_pdc_get_selected_config_input_new:
 *
 * Allocates a new #QmiMessagePdcGetSelectedConfigInput.
 *
 * Returns: the newly created #QmiMessagePdcGetSelectedConfigInput. The returned value should be freed with qmi_message_pdc_get_selected_config_input_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcGetSelectedConfigInput *qmi_message_pdc_get_selected_config_input_new (void);

/* --- Output -- */

/**
 * QmiMessagePdcGetSelectedConfigOutput:
 *
 * The #QmiMessagePdcGetSelectedConfigOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcGetSelectedConfigOutput QmiMessagePdcGetSelectedConfigOutput;
GType qmi_message_pdc_get_selected_config_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_GET_SELECTED_CONFIG_OUTPUT (qmi_message_pdc_get_selected_config_output_get_type ())


/**
 * qmi_message_pdc_get_selected_config_output_get_token:
 * @self: a #QmiMessagePdcGetSelectedConfigOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_selected_config_output_get_token (
    QmiMessagePdcGetSelectedConfigOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_get_selected_config_output_get_result:
 * @self: a QmiMessagePdcGetSelectedConfigOutput.
 * @error: Return location for error or %NULL.
 *
 * Get the result of the QMI operation.
 *
 * Returns: (skip): %TRUE if the QMI operation succeeded, %FALSE if @error is set.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_selected_config_output_get_result (
    QmiMessagePdcGetSelectedConfigOutput *self,
    GError **error);


/**
 * qmi_message_pdc_get_selected_config_output_ref:
 * @self: a #QmiMessagePdcGetSelectedConfigOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcGetSelectedConfigOutput *qmi_message_pdc_get_selected_config_output_ref (QmiMessagePdcGetSelectedConfigOutput *self);

/**
 * qmi_message_pdc_get_selected_config_output_unref:
 * @self: a #QmiMessagePdcGetSelectedConfigOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_get_selected_config_output_unref (QmiMessagePdcGetSelectedConfigOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcGetSelectedConfigOutput, qmi_message_pdc_get_selected_config_output_unref)

/**
 * qmi_message_pdc_get_selected_config_response_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiMessagePdcGetSelectedConfigOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiMessagePdcGetSelectedConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_get_selected_config_output_unref().
 *
 * Since: 1.34
 */
QmiMessagePdcGetSelectedConfigOutput *qmi_message_pdc_get_selected_config_response_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message PDC Set Selected Config */


/**
 * SECTION: qmi-message-pdc-set-selected-config
 * @title: PDC Set Selected Config response
 * @short_description: Methods to manage the PDC Set Selected Config response.
 *
 * Collection of methods to create requests and parse responses of the PDC Set Selected Config message.
 */

/* --- Input -- */

/**
 * QmiMessagePdcSetSelectedConfigInput:
 *
 * The #QmiMessagePdcSetSelectedConfigInput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcSetSelectedConfigInput QmiMessagePdcSetSelectedConfigInput;
GType qmi_message_pdc_set_selected_config_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_SET_SELECTED_CONFIG_INPUT (qmi_message_pdc_set_selected_config_input_get_type ())


/**
 * qmi_message_pdc_set_selected_config_input_get_token:
 * @self: a #QmiMessagePdcSetSelectedConfigInput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_set_selected_config_input_get_token (
    QmiMessagePdcSetSelectedConfigInput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_set_selected_config_input_set_token:
 * @self: a #QmiMessagePdcSetSelectedConfigInput.
 * @value_token: a #guint32.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Token' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_set_selected_config_input_set_token (
    QmiMessagePdcSetSelectedConfigInput *self,
    guint32 value_token,
    GError **error);


/**
 * qmi_message_pdc_set_selected_config_input_get_type_with_id_v2:
 * @self: a #QmiMessagePdcSetSelectedConfigInput.
 * @value_type_with_id_v2_config_type: (out)(optional): a placeholder for the output #QmiPdcConfigurationType, or %NULL if not required.
 * @value_type_with_id_v2_id: (out)(optional)(element-type guint8)(transfer none): a placeholder for the output #GArray of #guint8 elements, or %NULL if not required. Do not free it, it is owned by @self.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Type With Id v2' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_message_pdc_set_selected_config_input_get_type_with_id_v2 (
    QmiMessagePdcSetSelectedConfigInput *self,
    QmiPdcConfigurationType *value_type_with_id_v2_config_type,
    GArray **value_type_with_id_v2_id,
    GError **error);


/**
 * qmi_message_pdc_set_selected_config_input_set_type_with_id_v2:
 * @self: a #QmiMessagePdcSetSelectedConfigInput.
 * @value_type_with_id_v2_config_type: a #QmiPdcConfigurationType.
 * @value_type_with_id_v2_id: (in)(element-type guint8)(transfer none): a #GArray of #guint8 elements. A new reference to @value_type_with_id_v2_id will be taken, so the caller must make sure the array was created with the correct #GDestroyNotify as clear function for each element in the array.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Type With Id v2' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_message_pdc_set_selected_config_input_set_type_with_id_v2 (
    QmiMessagePdcSetSelectedConfigInput *self,
    QmiPdcConfigurationType value_type_with_id_v2_config_type,
    GArray *value_type_with_id_v2_id,
    GError **error);


/**
 * qmi_message_pdc_set_selected_config_input_ref:
 * @self: a #QmiMessagePdcSetSelectedConfigInput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcSetSelectedConfigInput *qmi_message_pdc_set_selected_config_input_ref (QmiMessagePdcSetSelectedConfigInput *self);

/**
 * qmi_message_pdc_set_selected_config_input_unref:
 * @self: a #QmiMessagePdcSetSelectedConfigInput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_set_selected_config_input_unref (QmiMessagePdcSetSelectedConfigInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcSetSelectedConfigInput, qmi_message_pdc_set_selected_config_input_unref)

/**
 * qmi_message_pdc_set_selected_config_input_new:
 *
 * Allocates a new #QmiMessagePdcSetSelectedConfigInput.
 *
 * Returns: the newly created #QmiMessagePdcSetSelectedConfigInput. The returned value should be freed with qmi_message_pdc_set_selected_config_input_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcSetSelectedConfigInput *qmi_message_pdc_set_selected_config_input_new (void);

/* --- Output -- */

/**
 * QmiMessagePdcSetSelectedConfigOutput:
 *
 * The #QmiMessagePdcSetSelectedConfigOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcSetSelectedConfigOutput QmiMessagePdcSetSelectedConfigOutput;
GType qmi_message_pdc_set_selected_config_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_SET_SELECTED_CONFIG_OUTPUT (qmi_message_pdc_set_selected_config_output_get_type ())


/**
 * qmi_message_pdc_set_selected_config_output_get_token:
 * @self: a #QmiMessagePdcSetSelectedConfigOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_set_selected_config_output_get_token (
    QmiMessagePdcSetSelectedConfigOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_set_selected_config_output_get_result:
 * @self: a QmiMessagePdcSetSelectedConfigOutput.
 * @error: Return location for error or %NULL.
 *
 * Get the result of the QMI operation.
 *
 * Returns: (skip): %TRUE if the QMI operation succeeded, %FALSE if @error is set.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_set_selected_config_output_get_result (
    QmiMessagePdcSetSelectedConfigOutput *self,
    GError **error);


/**
 * qmi_message_pdc_set_selected_config_output_ref:
 * @self: a #QmiMessagePdcSetSelectedConfigOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcSetSelectedConfigOutput *qmi_message_pdc_set_selected_config_output_ref (QmiMessagePdcSetSelectedConfigOutput *self);

/**
 * qmi_message_pdc_set_selected_config_output_unref:
 * @self: a #QmiMessagePdcSetSelectedConfigOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_set_selected_config_output_unref (QmiMessagePdcSetSelectedConfigOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcSetSelectedConfigOutput, qmi_message_pdc_set_selected_config_output_unref)

/**
 * qmi_message_pdc_set_selected_config_response_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiMessagePdcSetSelectedConfigOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiMessagePdcSetSelectedConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_set_selected_config_output_unref().
 *
 * Since: 1.34
 */
QmiMessagePdcSetSelectedConfigOutput *qmi_message_pdc_set_selected_config_response_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message PDC List Configs */


/**
 * SECTION: qmi-message-pdc-list-configs
 * @title: PDC List Configs response
 * @short_description: Methods to manage the PDC List Configs response.
 *
 * Collection of methods to create requests and parse responses of the PDC List Configs message.
 */

/* --- Input -- */

/**
 * QmiMessagePdcListConfigsInput:
 *
 * The #QmiMessagePdcListConfigsInput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcListConfigsInput QmiMessagePdcListConfigsInput;
GType qmi_message_pdc_list_configs_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_LIST_CONFIGS_INPUT (qmi_message_pdc_list_configs_input_get_type ())


/**
 * qmi_message_pdc_list_configs_input_get_config_type:
 * @self: a #QmiMessagePdcListConfigsInput.
 * @value_config_type: (out)(optional): a placeholder for the output #QmiPdcConfigurationType, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Config Type' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_list_configs_input_get_config_type (
    QmiMessagePdcListConfigsInput *self,
    QmiPdcConfigurationType *value_config_type,
    GError **error);


/**
 * qmi_message_pdc_list_configs_input_set_config_type:
 * @self: a #QmiMessagePdcListConfigsInput.
 * @value_config_type: a #QmiPdcConfigurationType.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Config Type' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_list_configs_input_set_config_type (
    QmiMessagePdcListConfigsInput *self,
    QmiPdcConfigurationType value_config_type,
    GError **error);


/**
 * qmi_message_pdc_list_configs_input_get_token:
 * @self: a #QmiMessagePdcListConfigsInput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_list_configs_input_get_token (
    QmiMessagePdcListConfigsInput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_list_configs_input_set_token:
 * @self: a #QmiMessagePdcListConfigsInput.
 * @value_token: a #guint32.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Token' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_list_configs_input_set_token (
    QmiMessagePdcListConfigsInput *self,
    guint32 value_token,
    GError **error);


/**
 * qmi_message_pdc_list_configs_input_ref:
 * @self: a #QmiMessagePdcListConfigsInput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcListConfigsInput *qmi_message_pdc_list_configs_input_ref (QmiMessagePdcListConfigsInput *self);

/**
 * qmi_message_pdc_list_configs_input_unref:
 * @self: a #QmiMessagePdcListConfigsInput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_list_configs_input_unref (QmiMessagePdcListConfigsInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcListConfigsInput, qmi_message_pdc_list_configs_input_unref)

/**
 * qmi_message_pdc_list_configs_input_new:
 *
 * Allocates a new #QmiMessagePdcListConfigsInput.
 *
 * Returns: the newly created #QmiMessagePdcListConfigsInput. The returned value should be freed with qmi_message_pdc_list_configs_input_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcListConfigsInput *qmi_message_pdc_list_configs_input_new (void);

/* --- Output -- */

/**
 * QmiMessagePdcListConfigsOutput:
 *
 * The #QmiMessagePdcListConfigsOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcListConfigsOutput QmiMessagePdcListConfigsOutput;
GType qmi_message_pdc_list_configs_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_LIST_CONFIGS_OUTPUT (qmi_message_pdc_list_configs_output_get_type ())


/**
 * qmi_message_pdc_list_configs_output_get_result:
 * @self: a QmiMessagePdcListConfigsOutput.
 * @error: Return location for error or %NULL.
 *
 * Get the result of the QMI operation.
 *
 * Returns: (skip): %TRUE if the QMI operation succeeded, %FALSE if @error is set.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_list_configs_output_get_result (
    QmiMessagePdcListConfigsOutput *self,
    GError **error);


/**
 * qmi_message_pdc_list_configs_output_ref:
 * @self: a #QmiMessagePdcListConfigsOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcListConfigsOutput *qmi_message_pdc_list_configs_output_ref (QmiMessagePdcListConfigsOutput *self);

/**
 * qmi_message_pdc_list_configs_output_unref:
 * @self: a #QmiMessagePdcListConfigsOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_list_configs_output_unref (QmiMessagePdcListConfigsOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcListConfigsOutput, qmi_message_pdc_list_configs_output_unref)

/**
 * qmi_message_pdc_list_configs_response_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiMessagePdcListConfigsOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiMessagePdcListConfigsOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_list_configs_output_unref().
 *
 * Since: 1.34
 */
QmiMessagePdcListConfigsOutput *qmi_message_pdc_list_configs_response_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message PDC Activate Config */


/**
 * SECTION: qmi-message-pdc-activate-config
 * @title: PDC Activate Config response
 * @short_description: Methods to manage the PDC Activate Config response.
 *
 * Collection of methods to create requests and parse responses of the PDC Activate Config message.
 */

/* --- Input -- */

/**
 * QmiMessagePdcActivateConfigInput:
 *
 * The #QmiMessagePdcActivateConfigInput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcActivateConfigInput QmiMessagePdcActivateConfigInput;
GType qmi_message_pdc_activate_config_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_ACTIVATE_CONFIG_INPUT (qmi_message_pdc_activate_config_input_get_type ())


/**
 * qmi_message_pdc_activate_config_input_get_token:
 * @self: a #QmiMessagePdcActivateConfigInput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_activate_config_input_get_token (
    QmiMessagePdcActivateConfigInput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_activate_config_input_set_token:
 * @self: a #QmiMessagePdcActivateConfigInput.
 * @value_token: a #guint32.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Token' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_activate_config_input_set_token (
    QmiMessagePdcActivateConfigInput *self,
    guint32 value_token,
    GError **error);


/**
 * qmi_message_pdc_activate_config_input_get_config_type:
 * @self: a #QmiMessagePdcActivateConfigInput.
 * @value_config_type: (out)(optional): a placeholder for the output #QmiPdcConfigurationType, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Config Type' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_activate_config_input_get_config_type (
    QmiMessagePdcActivateConfigInput *self,
    QmiPdcConfigurationType *value_config_type,
    GError **error);


/**
 * qmi_message_pdc_activate_config_input_set_config_type:
 * @self: a #QmiMessagePdcActivateConfigInput.
 * @value_config_type: a #QmiPdcConfigurationType.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Config Type' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_activate_config_input_set_config_type (
    QmiMessagePdcActivateConfigInput *self,
    QmiPdcConfigurationType value_config_type,
    GError **error);


/**
 * qmi_message_pdc_activate_config_input_ref:
 * @self: a #QmiMessagePdcActivateConfigInput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcActivateConfigInput *qmi_message_pdc_activate_config_input_ref (QmiMessagePdcActivateConfigInput *self);

/**
 * qmi_message_pdc_activate_config_input_unref:
 * @self: a #QmiMessagePdcActivateConfigInput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_activate_config_input_unref (QmiMessagePdcActivateConfigInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcActivateConfigInput, qmi_message_pdc_activate_config_input_unref)

/**
 * qmi_message_pdc_activate_config_input_new:
 *
 * Allocates a new #QmiMessagePdcActivateConfigInput.
 *
 * Returns: the newly created #QmiMessagePdcActivateConfigInput. The returned value should be freed with qmi_message_pdc_activate_config_input_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcActivateConfigInput *qmi_message_pdc_activate_config_input_new (void);

/* --- Output -- */

/**
 * QmiMessagePdcActivateConfigOutput:
 *
 * The #QmiMessagePdcActivateConfigOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcActivateConfigOutput QmiMessagePdcActivateConfigOutput;
GType qmi_message_pdc_activate_config_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_ACTIVATE_CONFIG_OUTPUT (qmi_message_pdc_activate_config_output_get_type ())


/**
 * qmi_message_pdc_activate_config_output_get_token:
 * @self: a #QmiMessagePdcActivateConfigOutput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_activate_config_output_get_token (
    QmiMessagePdcActivateConfigOutput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_activate_config_output_get_result:
 * @self: a QmiMessagePdcActivateConfigOutput.
 * @error: Return location for error or %NULL.
 *
 * Get the result of the QMI operation.
 *
 * Returns: (skip): %TRUE if the QMI operation succeeded, %FALSE if @error is set.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_activate_config_output_get_result (
    QmiMessagePdcActivateConfigOutput *self,
    GError **error);


/**
 * qmi_message_pdc_activate_config_output_ref:
 * @self: a #QmiMessagePdcActivateConfigOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcActivateConfigOutput *qmi_message_pdc_activate_config_output_ref (QmiMessagePdcActivateConfigOutput *self);

/**
 * qmi_message_pdc_activate_config_output_unref:
 * @self: a #QmiMessagePdcActivateConfigOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_activate_config_output_unref (QmiMessagePdcActivateConfigOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcActivateConfigOutput, qmi_message_pdc_activate_config_output_unref)

/**
 * qmi_message_pdc_activate_config_response_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiMessagePdcActivateConfigOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiMessagePdcActivateConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_activate_config_output_unref().
 *
 * Since: 1.34
 */
QmiMessagePdcActivateConfigOutput *qmi_message_pdc_activate_config_response_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message PDC Get Config Info */


/**
 * SECTION: qmi-message-pdc-get-config-info
 * @title: PDC Get Config Info response
 * @short_description: Methods to manage the PDC Get Config Info response.
 *
 * Collection of methods to create requests and parse responses of the PDC Get Config Info message.
 */

/* --- Input -- */

/**
 * QmiMessagePdcGetConfigInfoInput:
 *
 * The #QmiMessagePdcGetConfigInfoInput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcGetConfigInfoInput QmiMessagePdcGetConfigInfoInput;
GType qmi_message_pdc_get_config_info_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_GET_CONFIG_INFO_INPUT (qmi_message_pdc_get_config_info_input_get_type ())


/**
 * qmi_message_pdc_get_config_info_input_get_token:
 * @self: a #QmiMessagePdcGetConfigInfoInput.
 * @value_token: (out)(optional): a placeholder for the output #guint32, or %NULL if not required.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Token' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_config_info_input_get_token (
    QmiMessagePdcGetConfigInfoInput *self,
    guint32 *value_token,
    GError **error);


/**
 * qmi_message_pdc_get_config_info_input_set_token:
 * @self: a #QmiMessagePdcGetConfigInfoInput.
 * @value_token: a #guint32.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Token' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_config_info_input_set_token (
    QmiMessagePdcGetConfigInfoInput *self,
    guint32 value_token,
    GError **error);


/**
 * qmi_message_pdc_get_config_info_input_get_type_with_id_v2:
 * @self: a #QmiMessagePdcGetConfigInfoInput.
 * @value_type_with_id_v2_config_type: (out)(optional): a placeholder for the output #QmiPdcConfigurationType, or %NULL if not required.
 * @value_type_with_id_v2_id: (out)(optional)(element-type guint8)(transfer none): a placeholder for the output #GArray of #guint8 elements, or %NULL if not required. Do not free it, it is owned by @self.
 * @error: Return location for error or %NULL.
 *
 * Get the 'Type With Id v2' field from @self.
 *
 * Returns: (skip): %TRUE if the field is found, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_message_pdc_get_config_info_input_get_type_with_id_v2 (
    QmiMessagePdcGetConfigInfoInput *self,
    QmiPdcConfigurationType *value_type_with_id_v2_config_type,
    GArray **value_type_with_id_v2_id,
    GError **error);


/**
 * qmi_message_pdc_get_config_info_input_set_type_with_id_v2:
 * @self: a #QmiMessagePdcGetConfigInfoInput.
 * @value_type_with_id_v2_config_type: a #QmiPdcConfigurationType.
 * @value_type_with_id_v2_id: (in)(element-type guint8)(transfer none): a #GArray of #guint8 elements. A new reference to @value_type_with_id_v2_id will be taken, so the caller must make sure the array was created with the correct #GDestroyNotify as clear function for each element in the array.
 * @error: Return location for error or %NULL.
 *
 * Set the 'Type With Id v2' field in the message.
 *
 * Returns: (skip): %TRUE if @value was successfully set, %FALSE otherwise.
 *
 * Since: 1.32
 */
gboolean qmi_message_pdc_get_config_info_input_set_type_with_id_v2 (
    QmiMessagePdcGetConfigInfoInput *self,
    QmiPdcConfigurationType value_type_with_id_v2_config_type,
    GArray *value_type_with_id_v2_id,
    GError **error);


/**
 * qmi_message_pdc_get_config_info_input_ref:
 * @self: a #QmiMessagePdcGetConfigInfoInput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcGetConfigInfoInput *qmi_message_pdc_get_config_info_input_ref (QmiMessagePdcGetConfigInfoInput *self);

/**
 * qmi_message_pdc_get_config_info_input_unref:
 * @self: a #QmiMessagePdcGetConfigInfoInput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_get_config_info_input_unref (QmiMessagePdcGetConfigInfoInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcGetConfigInfoInput, qmi_message_pdc_get_config_info_input_unref)

/**
 * qmi_message_pdc_get_config_info_input_new:
 *
 * Allocates a new #QmiMessagePdcGetConfigInfoInput.
 *
 * Returns: the newly created #QmiMessagePdcGetConfigInfoInput. The returned value should be freed with qmi_message_pdc_get_config_info_input_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcGetConfigInfoInput *qmi_message_pdc_get_config_info_input_new (void);

/* --- Output -- */

/**
 * QmiMessagePdcGetConfigInfoOutput:
 *
 * The #QmiMessagePdcGetConfigInfoOutput structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
typedef struct _QmiMessagePdcGetConfigInfoOutput QmiMessagePdcGetConfigInfoOutput;
GType qmi_message_pdc_get_config_info_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_PDC_GET_CONFIG_INFO_OUTPUT (qmi_message_pdc_get_config_info_output_get_type ())


/**
 * qmi_message_pdc_get_config_info_output_get_result:
 * @self: a QmiMessagePdcGetConfigInfoOutput.
 * @error: Return location for error or %NULL.
 *
 * Get the result of the QMI operation.
 *
 * Returns: (skip): %TRUE if the QMI operation succeeded, %FALSE if @error is set.
 *
 * Since: 1.18
 */
gboolean qmi_message_pdc_get_config_info_output_get_result (
    QmiMessagePdcGetConfigInfoOutput *self,
    GError **error);


/**
 * qmi_message_pdc_get_config_info_output_ref:
 * @self: a #QmiMessagePdcGetConfigInfoOutput.
 *
 * Atomically increments the reference count of @self by one.
 *
 * Returns: the new reference to @self.
 *
 * Since: 1.18
 */
QmiMessagePdcGetConfigInfoOutput *qmi_message_pdc_get_config_info_output_ref (QmiMessagePdcGetConfigInfoOutput *self);

/**
 * qmi_message_pdc_get_config_info_output_unref:
 * @self: a #QmiMessagePdcGetConfigInfoOutput.
 *
 * Atomically decrements the reference count of @self by one.
 * If the reference count drops to 0, @self is completely disposed.
 *
 * Since: 1.18
 */
void qmi_message_pdc_get_config_info_output_unref (QmiMessagePdcGetConfigInfoOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessagePdcGetConfigInfoOutput, qmi_message_pdc_get_config_info_output_unref)

/**
 * qmi_message_pdc_get_config_info_response_parse:
 * @message: a #QmiMessage.
 * @error: return location for error or %NULL.
 *
 * Parses a #QmiMessage and builds a #QmiMessagePdcGetConfigInfoOutput out of it.
 * The operation fails if the message is of the wrong type.
 *
 * Returns: a #QmiMessagePdcGetConfigInfoOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_get_config_info_output_unref().
 *
 * Since: 1.34
 */
QmiMessagePdcGetConfigInfoOutput *qmi_message_pdc_get_config_info_response_parse (
    QmiMessage *message,
    GError **error);

/*****************************************************************************/
/* Service-specific utils: PDC */


#if defined (LIBQMI_GLIB_COMPILATION)

G_GNUC_INTERNAL
gchar *__qmi_message_pdc_get_printable (
    QmiMessage *self,
    QmiMessageContext *context,
    const gchar *line_prefix);

#endif


#define HAVE_QMI_SERVICE_PDC

/*****************************************************************************/
/* CLIENT: QMI Client PDC */

#define QMI_TYPE_CLIENT_PDC            (qmi_client_pdc_get_type ())
#define QMI_CLIENT_PDC(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), QMI_TYPE_CLIENT_PDC, QmiClientPdc))
#define QMI_CLIENT_PDC_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  QMI_TYPE_CLIENT_PDC, QmiClientPdcClass))
#define QMI_IS_CLIENT_PDC(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), QMI_TYPE_CLIENT_PDC))
#define QMI_IS_CLIENT_PDC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  QMI_TYPE_CLIENT_PDC))
#define QMI_CLIENT_PDC_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  QMI_TYPE_CLIENT_PDC, QmiClientPdcClass))

typedef struct _QmiClientPdc QmiClientPdc;
typedef struct _QmiClientPdcClass QmiClientPdcClass;

/**
 * QmiClientPdc:
 *
 * The #QmiClientPdc structure contains private data and should only be accessed
 * using the provided API.
 *
 * Since: 1.18
 */
struct _QmiClientPdc {
    /*< private >*/
    QmiClient parent;
    gpointer priv_unused;
};

struct _QmiClientPdcClass {
    /*< private >*/
    QmiClientClass parent;
};

GType qmi_client_pdc_get_type (void);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiClientPdc, g_object_unref)

/**
 * qmi_client_pdc_register:
 * @self: a #QmiClientPdc.
 * @input: a #QmiMessagePdcRegisterInput.
 * @timeout: maximum time to wait for the method to complete, in seconds.
 * @cancellable: a #GCancellable or %NULL.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: user data to pass to @callback.
 *
 * Asynchronously sends a Register request to the device.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from.
 *
 * You can then call qmi_client_pdc_register_finish() to get the result of the operation.
 *
 * Since: 1.18
 */
void qmi_client_pdc_register (
    QmiClientPdc *self,
    QmiMessagePdcRegisterInput *input,
    guint timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

/**
 * qmi_client_pdc_register_finish:
 * @self: a #QmiClientPdc.
 * @res: the #GAsyncResult obtained from the #GAsyncReadyCallback passed to qmi_client_pdc_register().
 * @error: Return location for error or %NULL.
 *
 * Finishes an async operation started with qmi_client_pdc_register().
 *
 * Returns: a #QmiMessagePdcRegisterOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_register_output_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcRegisterOutput *qmi_client_pdc_register_finish (
    QmiClientPdc *self,
    GAsyncResult *res,
    GError **error);

/**
 * qmi_client_pdc_get_selected_config:
 * @self: a #QmiClientPdc.
 * @input: a #QmiMessagePdcGetSelectedConfigInput.
 * @timeout: maximum time to wait for the method to complete, in seconds.
 * @cancellable: a #GCancellable or %NULL.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: user data to pass to @callback.
 *
 * Asynchronously sends a Get Selected Config request to the device.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from.
 *
 * You can then call qmi_client_pdc_get_selected_config_finish() to get the result of the operation.
 *
 * Since: 1.18
 */
void qmi_client_pdc_get_selected_config (
    QmiClientPdc *self,
    QmiMessagePdcGetSelectedConfigInput *input,
    guint timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

/**
 * qmi_client_pdc_get_selected_config_finish:
 * @self: a #QmiClientPdc.
 * @res: the #GAsyncResult obtained from the #GAsyncReadyCallback passed to qmi_client_pdc_get_selected_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an async operation started with qmi_client_pdc_get_selected_config().
 *
 * Returns: a #QmiMessagePdcGetSelectedConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_get_selected_config_output_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcGetSelectedConfigOutput *qmi_client_pdc_get_selected_config_finish (
    QmiClientPdc *self,
    GAsyncResult *res,
    GError **error);

/**
 * qmi_client_pdc_set_selected_config:
 * @self: a #QmiClientPdc.
 * @input: a #QmiMessagePdcSetSelectedConfigInput.
 * @timeout: maximum time to wait for the method to complete, in seconds.
 * @cancellable: a #GCancellable or %NULL.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: user data to pass to @callback.
 *
 * Asynchronously sends a Set Selected Config request to the device.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from.
 *
 * You can then call qmi_client_pdc_set_selected_config_finish() to get the result of the operation.
 *
 * Since: 1.18
 */
void qmi_client_pdc_set_selected_config (
    QmiClientPdc *self,
    QmiMessagePdcSetSelectedConfigInput *input,
    guint timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

/**
 * qmi_client_pdc_set_selected_config_finish:
 * @self: a #QmiClientPdc.
 * @res: the #GAsyncResult obtained from the #GAsyncReadyCallback passed to qmi_client_pdc_set_selected_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an async operation started with qmi_client_pdc_set_selected_config().
 *
 * Returns: a #QmiMessagePdcSetSelectedConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_set_selected_config_output_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcSetSelectedConfigOutput *qmi_client_pdc_set_selected_config_finish (
    QmiClientPdc *self,
    GAsyncResult *res,
    GError **error);

/**
 * qmi_client_pdc_list_configs:
 * @self: a #QmiClientPdc.
 * @input: a #QmiMessagePdcListConfigsInput.
 * @timeout: maximum time to wait for the method to complete, in seconds.
 * @cancellable: a #GCancellable or %NULL.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: user data to pass to @callback.
 *
 * Asynchronously sends a List Configs request to the device.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from.
 *
 * You can then call qmi_client_pdc_list_configs_finish() to get the result of the operation.
 *
 * Since: 1.18
 */
void qmi_client_pdc_list_configs (
    QmiClientPdc *self,
    QmiMessagePdcListConfigsInput *input,
    guint timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

/**
 * qmi_client_pdc_list_configs_finish:
 * @self: a #QmiClientPdc.
 * @res: the #GAsyncResult obtained from the #GAsyncReadyCallback passed to qmi_client_pdc_list_configs().
 * @error: Return location for error or %NULL.
 *
 * Finishes an async operation started with qmi_client_pdc_list_configs().
 *
 * Returns: a #QmiMessagePdcListConfigsOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_list_configs_output_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcListConfigsOutput *qmi_client_pdc_list_configs_finish (
    QmiClientPdc *self,
    GAsyncResult *res,
    GError **error);

/**
 * qmi_client_pdc_activate_config:
 * @self: a #QmiClientPdc.
 * @input: a #QmiMessagePdcActivateConfigInput.
 * @timeout: maximum time to wait for the method to complete, in seconds.
 * @cancellable: a #GCancellable or %NULL.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: user data to pass to @callback.
 *
 * Asynchronously sends a Activate Config request to the device.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from.
 *
 * You can then call qmi_client_pdc_activate_config_finish() to get the result of the operation.
 *
 * Since: 1.18
 */
void qmi_client_pdc_activate_config (
    QmiClientPdc *self,
    QmiMessagePdcActivateConfigInput *input,
    guint timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

/**
 * qmi_client_pdc_activate_config_finish:
 * @self: a #QmiClientPdc.
 * @res: the #GAsyncResult obtained from the #GAsyncReadyCallback passed to qmi_client_pdc_activate_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an async operation started with qmi_client_pdc_activate_config().
 *
 * Returns: a #QmiMessagePdcActivateConfigOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_activate_config_output_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcActivateConfigOutput *qmi_client_pdc_activate_config_finish (
    QmiClientPdc *self,
    GAsyncResult *res,
    GError **error);

/**
 * qmi_client_pdc_get_config_info:
 * @self: a #QmiClientPdc.
 * @input: a #QmiMessagePdcGetConfigInfoInput.
 * @timeout: maximum time to wait for the method to complete, in seconds.
 * @cancellable: a #GCancellable or %NULL.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: user data to pass to @callback.
 *
 * Asynchronously sends a Get Config Info request to the device.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from.
 *
 * You can then call qmi_client_pdc_get_config_info_finish() to get the result of the operation.
 *
 * Since: 1.18
 */
void qmi_client_pdc_get_config_info (
    QmiClientPdc *self,
    QmiMessagePdcGetConfigInfoInput *input,
    guint timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data);

/**
 * qmi_client_pdc_get_config_info_finish:
 * @self: a #QmiClientPdc.
 * @res: the #GAsyncResult obtained from the #GAsyncReadyCallback passed to qmi_client_pdc_get_config_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an async operation started with qmi_client_pdc_get_config_info().
 *
 * Returns: a #QmiMessagePdcGetConfigInfoOutput, or %NULL if @error is set. The returned value should be freed with qmi_message_pdc_get_config_info_output_unref().
 *
 * Since: 1.18
 */
QmiMessagePdcGetConfigInfoOutput *qmi_client_pdc_get_config_info_finish (
    QmiClientPdc *self,
    GAsyncResult *res,
    GError **error);

G_END_DECLS

#endif /* __LIBQMI_GLIB_QMI_PDC__ */
