// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeUInt64Array
 * @brief   strided implicit array of vtkTypeUInt64.
 *
 * vtkStridedTypeUInt64Array is an strided implicit array of values of type vtkTypeUInt64.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeUInt64Array_h
#define vtkStridedTypeUInt64Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeUInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeUInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeUInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeUInt64Array* New();
  static vtkStridedTypeUInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeUInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeUInt64Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeUInt64* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeUInt64* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeUInt64* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeUInt64Array();
  ~vtkStridedTypeUInt64Array() override;

private:
  typedef vtkStridedArray<vtkTypeUInt64> RealSuperclass;

  vtkStridedTypeUInt64Array(const vtkStridedTypeUInt64Array&) = delete;
  void operator=(const vtkStridedTypeUInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeUInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
