// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeUInt8Array
 * @brief   scaled soa array of vtkTypeUInt8.
 *
 * vtkScaledSOATypeUInt8Array is a scaled soa array of values of type vtkTypeUInt8.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeUInt8Array_h
#define vtkScaledSOATypeUInt8Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeUInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeUInt8Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeUInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeUInt8Array* New();
  static vtkScaledSOATypeUInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeUInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeUInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeUInt8Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeUInt8Array();
  ~vtkScaledSOATypeUInt8Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeUInt8> RealSuperclass;

  vtkScaledSOATypeUInt8Array(const vtkScaledSOATypeUInt8Array&) = delete;
  void operator=(const vtkScaledSOATypeUInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeUInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
