// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeInt16Array
 * @brief   soa array of vtkTypeInt16.
 *
 * vtkSOATypeInt16Array is a soa array of values of type vtkTypeInt16.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeInt16Array_h
#define vtkSOATypeInt16Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeInt16Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeInt16Array* New();
  static vtkSOATypeInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeInt16Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeInt16Array();
  ~vtkSOATypeInt16Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeInt16> RealSuperclass;

  vtkSOATypeInt16Array(const vtkSOATypeInt16Array&) = delete;
  void operator=(const vtkSOATypeInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
