// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedUnsignedCharArray
 * @brief   indexed implicit array of unsigned char.
 *
 * vtkIndexedUnsignedCharArray is an indexed implicit array of values of type unsigned char.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedUnsignedCharArray_h
#define vtkIndexedUnsignedCharArray_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<unsigned char>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkIndexedType*Array instead") vtkIndexedUnsignedCharArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedUnsignedCharArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedUnsignedCharArray* New();
  static vtkIndexedUnsignedCharArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned char);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedUnsignedCharArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedUnsignedCharArray*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedUnsignedCharArray();
  ~vtkIndexedUnsignedCharArray() override;

private:
  typedef vtkIndexedArray<unsigned char> RealSuperclass;

  vtkIndexedUnsignedCharArray(const vtkIndexedUnsignedCharArray&) = delete;
  void operator=(const vtkIndexedUnsignedCharArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedUnsignedCharArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
