// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedTypeInt32Array
 * @brief   indexed implicit array of vtkTypeInt32.
 *
 * vtkIndexedTypeInt32Array is an indexed implicit array of values of type vtkTypeInt32.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedTypeInt32Array_h
#define vtkIndexedTypeInt32Array_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<vtkTypeInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkIndexedTypeInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedTypeInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedTypeInt32Array* New();
  static vtkIndexedTypeInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedTypeInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedTypeInt32Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedTypeInt32Array();
  ~vtkIndexedTypeInt32Array() override;

private:
  typedef vtkIndexedArray<vtkTypeInt32> RealSuperclass;

  vtkIndexedTypeInt32Array(const vtkIndexedTypeInt32Array&) = delete;
  void operator=(const vtkIndexedTypeInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedTypeInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
