// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineTypeUInt32Array
 * @brief   affine implicit array of vtkTypeUInt32.
 *
 * vtkAffineTypeUInt32Array is an affine implicit array of values of type vtkTypeUInt32.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineTypeUInt32Array_h
#define vtkAffineTypeUInt32Array_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<vtkTypeUInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkAffineTypeUInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineTypeUInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineTypeUInt32Array* New();
  static vtkAffineTypeUInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineTypeUInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineTypeUInt32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(vtkTypeUInt32 slope, vtkTypeUInt32 intercept);

protected:
  vtkAffineTypeUInt32Array();
  ~vtkAffineTypeUInt32Array() override;

private:
  typedef vtkAffineArray<vtkTypeUInt32> RealSuperclass;

  vtkAffineTypeUInt32Array(const vtkAffineTypeUInt32Array&) = delete;
  void operator=(const vtkAffineTypeUInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineTypeUInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
