#!/bin/bash

check() {
    # Only include this module if it's a live boot
    return 0
}

depends() {
    # Needed modules
    echo "base fs-lib img-lib"
    return 0
}

install() {
    # Install the mount script
    inst_hook pre-mount 20 "$moddir/mount-kdeosiso.sh"
    
    # Install required binaries
    inst_multiple mount umount mkdir grep awk sed blkid
    
    # Install kernel modules
    instmods overlay squashfs isofs loop
    
    # Install isomounts file (will be in the ISO)
    # Not installed here - it's read from the live medium at runtime
    
    return 0
}
