// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStridedTypeFloat64Array
 * @brief   strided implicit array of vtkTypeFloat64.
 *
 * vtkStridedTypeFloat64Array is an strided implicit array of values of type vtkTypeFloat64.
 * see vtkStridedArray, vtkStridedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStridedTypeFloat64Array_h
#define vtkStridedTypeFloat64Array_h

#include "vtkStridedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStridedArray<vtkTypeFloat64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStridedTypeFloat64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStridedTypeFloat64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStridedTypeFloat64Array* New();
  static vtkStridedTypeFloat64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStridedTypeFloat64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStridedTypeFloat64Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set the parameters for the strided backend.
   */
  void ConstructBackend(const vtkTypeFloat64* buffer, vtkIdType stride, int components, vtkIdType offset);
  void ConstructBackend(const vtkTypeFloat64* buffer, vtkIdType stride, int components);
  void ConstructBackend(const vtkTypeFloat64* buffer, vtkIdType stride);
  ///@}

protected:
  vtkStridedTypeFloat64Array();
  ~vtkStridedTypeFloat64Array() override;

private:
  typedef vtkStridedArray<vtkTypeFloat64> RealSuperclass;

  vtkStridedTypeFloat64Array(const vtkStridedTypeFloat64Array&) = delete;
  void operator=(const vtkStridedTypeFloat64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStridedTypeFloat64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
