// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeUInt64Array
 * @brief   scaled soa array of vtkTypeUInt64.
 *
 * vtkScaledSOATypeUInt64Array is a scaled soa array of values of type vtkTypeUInt64.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeUInt64Array_h
#define vtkScaledSOATypeUInt64Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeUInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeUInt64Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeUInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeUInt64Array* New();
  static vtkScaledSOATypeUInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeUInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeUInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeUInt64Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeUInt64Array();
  ~vtkScaledSOATypeUInt64Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeUInt64> RealSuperclass;

  vtkScaledSOATypeUInt64Array(const vtkScaledSOATypeUInt64Array&) = delete;
  void operator=(const vtkScaledSOATypeUInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeUInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
