// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeInt32Array
 * @brief   scaled soa array of vtkTypeInt32.
 *
 * vtkScaledSOATypeInt32Array is a scaled soa array of values of type vtkTypeInt32.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeInt32Array_h
#define vtkScaledSOATypeInt32Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeInt32Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeInt32Array* New();
  static vtkScaledSOATypeInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeInt32Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeInt32Array();
  ~vtkScaledSOATypeInt32Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeInt32> RealSuperclass;

  vtkScaledSOATypeInt32Array(const vtkScaledSOATypeInt32Array&) = delete;
  void operator=(const vtkScaledSOATypeInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
