// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeFloat32Array
 * @brief   scaled soa array of vtkTypeFloat32.
 *
 * vtkScaledSOATypeFloat32Array is a scaled soa array of values of type vtkTypeFloat32.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeFloat32Array_h
#define vtkScaledSOATypeFloat32Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeFloat32Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeFloat32Array* New();
  static vtkScaledSOATypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeFloat32Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeFloat32Array();
  ~vtkScaledSOATypeFloat32Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeFloat32> RealSuperclass;

  vtkScaledSOATypeFloat32Array(const vtkScaledSOATypeFloat32Array&) = delete;
  void operator=(const vtkScaledSOATypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
