// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeFloat64Array
 * @brief   soa array of vtkTypeFloat64.
 *
 * vtkSOATypeFloat64Array is a soa array of values of type vtkTypeFloat64.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeFloat64Array_h
#define vtkSOATypeFloat64Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeFloat64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeFloat64Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeFloat64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeFloat64Array* New();
  static vtkSOATypeFloat64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeFloat64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeFloat64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeFloat64Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeFloat64Array();
  ~vtkSOATypeFloat64Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeFloat64> RealSuperclass;

  vtkSOATypeFloat64Array(const vtkSOATypeFloat64Array&) = delete;
  void operator=(const vtkSOATypeFloat64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeFloat64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
