// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedTypeInt8Array
 * @brief   indexed implicit array of vtkTypeInt8.
 *
 * vtkIndexedTypeInt8Array is an indexed implicit array of values of type vtkTypeInt8.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedTypeInt8Array_h
#define vtkIndexedTypeInt8Array_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<vtkTypeInt8>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkIndexedTypeInt8Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedTypeInt8Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedTypeInt8Array* New();
  static vtkIndexedTypeInt8Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt8);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedTypeInt8Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedTypeInt8Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedTypeInt8Array();
  ~vtkIndexedTypeInt8Array() override;

private:
  typedef vtkIndexedArray<vtkTypeInt8> RealSuperclass;

  vtkIndexedTypeInt8Array(const vtkIndexedTypeInt8Array&) = delete;
  void operator=(const vtkIndexedTypeInt8Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedTypeInt8Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
