// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedTypeInt64Array
 * @brief   indexed implicit array of vtkTypeInt64.
 *
 * vtkIndexedTypeInt64Array is an indexed implicit array of values of type vtkTypeInt64.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedTypeInt64Array_h
#define vtkIndexedTypeInt64Array_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<vtkTypeInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkIndexedTypeInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedTypeInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedTypeInt64Array* New();
  static vtkIndexedTypeInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedTypeInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedTypeInt64Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedTypeInt64Array();
  ~vtkIndexedTypeInt64Array() override;

private:
  typedef vtkIndexedArray<vtkTypeInt64> RealSuperclass;

  vtkIndexedTypeInt64Array(const vtkIndexedTypeInt64Array&) = delete;
  void operator=(const vtkIndexedTypeInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedTypeInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
