// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedTypeFloat32Array
 * @brief   indexed implicit array of vtkTypeFloat32.
 *
 * vtkIndexedTypeFloat32Array is an indexed implicit array of values of type vtkTypeFloat32.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedTypeFloat32Array_h
#define vtkIndexedTypeFloat32Array_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkIndexedTypeFloat32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedTypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedTypeFloat32Array* New();
  static vtkIndexedTypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedTypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedTypeFloat32Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedTypeFloat32Array();
  ~vtkIndexedTypeFloat32Array() override;

private:
  typedef vtkIndexedArray<vtkTypeFloat32> RealSuperclass;

  vtkIndexedTypeFloat32Array(const vtkIndexedTypeFloat32Array&) = delete;
  void operator=(const vtkIndexedTypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedTypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
