// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeInt32Array
 * @brief   constant implicit array of vtkTypeInt32.
 *
 * vtkConstantTypeInt32Array is a constant implicit array of values of type vtkTypeInt32.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeInt32Array_h
#define vtkConstantTypeInt32Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt32);
#endif

  static vtkConstantTypeInt32Array* New();
  static vtkConstantTypeInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeInt32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeInt32 value);

protected:
  vtkConstantTypeInt32Array();
  ~vtkConstantTypeInt32Array() override;

private:
  typedef vtkConstantArray<vtkTypeInt32> RealSuperclass;

  vtkConstantTypeInt32Array(const vtkConstantTypeInt32Array&) = delete;
  void operator=(const vtkConstantTypeInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
