// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantLongArray
 * @brief   constant implicit array of long.
 *
 * vtkConstantLongArray is a constant implicit array of values of type long.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantLongArray_h
#define vtkConstantLongArray_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkConstantType*Array instead") vtkConstantLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(long);
#endif

  static vtkConstantLongArray* New();
  static vtkConstantLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantLongArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(long value);

protected:
  vtkConstantLongArray();
  ~vtkConstantLongArray() override;

private:
  typedef vtkConstantArray<long> RealSuperclass;

  vtkConstantLongArray(const vtkConstantLongArray&) = delete;
  void operator=(const vtkConstantLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
