// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeTypeUInt32Array
 * @brief   composite implicit array of vtkTypeUInt32.
 *
 * vtkCompositeTypeUInt32Array is a composite implicit array of values of type vtkTypeUInt32.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeTypeUInt32Array_h
#define vtkCompositeTypeUInt32Array_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<vtkTypeUInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT  vtkCompositeTypeUInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeTypeUInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeTypeUInt32Array* New();
  static vtkCompositeTypeUInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeTypeUInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeTypeUInt32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeTypeUInt32Array();
  ~vtkCompositeTypeUInt32Array() override;

private:
  typedef vtkCompositeArray<vtkTypeUInt32> RealSuperclass;

  vtkCompositeTypeUInt32Array(const vtkCompositeTypeUInt32Array&) = delete;
  void operator=(const vtkCompositeTypeUInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeTypeUInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
