"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SymlinkError = void 0;
class SymlinkError extends Error {
    path;
    symlink;
    syscall = 'symlink';
    code = 'TAR_SYMLINK_ERROR';
    constructor(symlink, path) {
        super('TAR_SYMLINK_ERROR: Cannot extract through symbolic link');
        this.symlink = symlink;
        this.path = path;
    }
    get name() {
        return 'SymlinkError';
    }
}
exports.SymlinkError = SymlinkError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/2bac84f8fa12a3764b4ce71e790f0a413b183f35/node_modules-tar-dist-commonjs-symlink-error.js.map