/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import liqp.TemplateContext;
import liqp.filters.Relative_Url;

public class Absolute_Url
extends Relative_Url {
    public static final String config = "config";
    public static final String url = "url";

    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        String valAsString = this.asString(value, context);
        if (this.isValidAbsoluteUrl(valAsString)) {
            return valAsString;
        }
        Object configRoot = context.get("site");
        Map<String, Object> siteMap = this.objectToMap(configRoot, context);
        String baseUrl = this.asString(siteMap.get("baseurl"), context);
        Object siteConfig = siteMap.get(config);
        Map<String, Object> configs = this.objectToMap(siteConfig, context);
        String siteUrl = this.asString(configs.get(url), context);
        String relativeUrl = this.getRelativeUrl(context, baseUrl, valAsString);
        if ("".equals(siteUrl)) {
            return relativeUrl;
        }
        String res = siteUrl != null && siteUrl.endsWith("/") && "/".equals(relativeUrl) ? siteUrl : siteUrl + relativeUrl;
        try {
            res = Absolute_Url.convertUnicodeURLToAscii(res);
            if (valAsString.endsWith("/") && !res.endsWith("/")) {
                res = res + "/";
            }
            return res;
        }
        catch (Exception e) {
            if (context.renderSettings.raiseExceptionsInStrictMode) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return res;
        }
    }

    public static String convertUnicodeURLToAscii(String url) throws URISyntaxException {
        if (url != null) {
            url = url.trim();
            URI uri = new URI(url);
            boolean includeScheme = true;
            if (uri.getScheme() == null) {
                uri = new URI("http://" + url);
                includeScheme = false;
            }
            String scheme = uri.getScheme() != null ? uri.getScheme() + "://" : null;
            String authority = uri.getRawAuthority() != null ? uri.getRawAuthority() : "";
            String path = uri.getRawPath() != null ? uri.getRawPath() : "";
            String queryString = uri.getRawQuery() != null ? "?" + uri.getRawQuery() : "";
            String fragment = uri.getRawFragment() != null ? "#" + uri.getRawFragment() : "";
            url = (includeScheme ? scheme : "") + IDN.toASCII(authority) + path + queryString + fragment;
            url = new URI(url).normalize().toASCIIString();
        }
        return url;
    }
}

