/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.reporter;

import com.virtuslab.using_directives.custom.utils.Position;
import com.virtuslab.using_directives.reporter.Reporter;

public class ConsoleReporter
implements Reporter {
    private int errorCount = 0;
    private int warningCount = 0;

    private String msgWithPos(Position pos, String msg) {
        return String.format("%d:%d:\n%s", pos.getLine(), pos.getLine(), msg);
    }

    private String errorMessage(String msg) {
        ++this.errorCount;
        return String.format("ERROR: %s", msg);
    }

    private String warningMessage(String msg) {
        return String.format("WARNING: %s", msg);
    }

    @Override
    public void error(String msg) {
        System.out.println(this.errorMessage(msg));
    }

    @Override
    public void warning(String msg) {
        ++this.warningCount;
        System.out.println(this.warningMessage(msg));
    }

    @Override
    public void error(Position position, String msg) {
        System.out.println(this.msgWithPos(position, this.errorMessage(msg)));
    }

    @Override
    public void warning(Position position, String msg) {
        System.out.println(this.msgWithPos(position, this.warningMessage(msg)));
    }

    @Override
    public boolean hasErrors() {
        return this.errorCount != 0;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningCount != 0;
    }

    @Override
    public void reset() {
        this.errorCount = 0;
    }
}

