# Noctalia shell

**_quiet by design_**

<p align="center">
  <img src="https://assets.noctalia.dev/noctalia-logo.svg?v=2" alt="Noctalia Logo" style="width: 192px" />
</p>

<p align="center">
  <a href="https://docs.noctalia.dev/getting-started/installation">
    <img
      src="https://img.shields.io/badge/🌙_Install_Noctalia-A8AEFF?style=for-the-badge&labelColor=0C0D11"
      alt="Install Noctalia"
      style="height: 50px"
    />
  </a>
</p>

<p><br/></p>

<p align="center">
  <a href="https://github.com/noctalia-dev/noctalia-shell/commits">
    <img src="https://img.shields.io/github/last-commit/noctalia-dev/noctalia-shell?style=for-the-badge&labelColor=0C0D11&color=A8AEFF&logo=git&logoColor=FFFFFF&label=commit" alt="Last commit" />
  </a>
  <a href="https://github.com/noctalia-dev/noctalia-shell/stargazers">
    <img src="https://img.shields.io/github/stars/noctalia-dev/noctalia-shell?style=for-the-badge&labelColor=0C0D11&color=A8AEFF&logo=github&logoColor=FFFFFF" alt="GitHub stars" />
  </a>
  <a href="https://docs.noctalia.dev">
    <img src="https://img.shields.io/badge/docs-A8AEFF?style=for-the-badge&logo=gitbook&logoColor=FFFFFF&labelColor=0C0D11" alt="Documentation" />
  </a>
  <a href="https://discord.noctalia.dev">
    <img src="https://img.shields.io/badge/discord-A8AEFF?style=for-the-badge&labelColor=0C0D11&logo=discord&logoColor=FFFFFF" alt="Discord" />
  </a>
</p>

---

## What is Noctalia?

A beautiful, minimal desktop shell for Wayland that actually gets out of your way. Built on [Quickshell](https://quickshell.outfoxxed.me/) (Qt/QML) with a warm lavender aesthetic that you can easily customize to match your vibe.

**✨ Key Features:**
- 🪟 Native support for Niri, Hyprland, Sway, Scroll, Labwc and MangoWC
- 🎨 Extensive theming with predefined color schemes and automatic color generation from your wallpaper
- 🖼️ Wallpaper management with Wallhaven integration
- 🔔 Notification system with history and Do Not Disturb
- 🖥️ Multi-monitor support
- 🔒 Lock screen
- 🧩 Desktop widgets (clock, media player and more)
- 💡 OSD for volume and brightness
- 🔌 30+ plugins available ([explore plugins](https://noctalia.dev/plugins/))
- 🪄 Setup wizard for first-time users
- ⚡ Built on Quickshell for performance
---

## Preview

https://github.com/user-attachments/assets/bf46f233-8d66-439a-a1ae-ab0446270f2d

<details>
<summary>Screenshots</summary>

![Dark 1](/Assets/Screenshots/noctalia-dark-1.png)
![Dark 2](/Assets/Screenshots/noctalia-dark-2.png)
![Dark 3](/Assets/Screenshots/noctalia-dark-3.png)

![Light 1](/Assets/Screenshots/noctalia-light-1.png)
![Light 2](/Assets/Screenshots/noctalia-light-2.png)
![Light 3](/Assets/Screenshots/noctalia-light-3.png)

</details>

---

## 📋 Requirements

- Wayland compositor (Niri, Hyprland, Sway, Scroll, MangoWC or labwc recommended)
- Quickshell
- Additional dependencies are listed in our [documentation](https://docs.noctalia.dev)

---

## 🚀 Getting Started

**New to Noctalia?**
Check out our comprehensive documentation and installation guide to get up and running!

<p align="center">
  <a href="https://docs.noctalia.dev/getting-started/installation">
    <img src="https://img.shields.io/badge/📖_Installation_Guide-A8AEFF?style=for-the-badge&logoColor=FFFFFF&labelColor=0C0D11" alt="Installation Guide" />
  </a>
  <a href="https://docs.noctalia.dev/getting-started/faq/">
    <img src="https://img.shields.io/badge/❓_FAQ-A8AEFF?style=for-the-badge&logoColor=FFFFFF&labelColor=0C0D11" alt="FAQ" />
  </a>
  <a href="https://discord.noctalia.dev">
    <img src="https://img.shields.io/badge/💬_Get_Help-A8AEFF?style=for-the-badge&logo=discord&logoColor=FFFFFF&labelColor=0C0D11" alt="Discord" />
  </a>
</p>

---

## 🖥️ Wayland Compositors

Noctalia provides native support for **Niri**, **Hyprland**, **Sway**, **Labwc** and **MangoWC**. Other Wayland compositors may work but could require additional configuration for compositor-specific features like workspaces and window management.

---

## 🤝 Contributing

We welcome contributions of any size - bug fixes, new features, documentation improvements, or custom themes and configs.

**Get involved:**
- **Found a bug?** [Open an issue](https://github.com/noctalia-dev/noctalia-shell/issues/new)
- **Want to code?** Check out our [development guidelines](https://docs.noctalia.dev/development/guideline)
- **Need help?** Join our [Discord](https://discord.noctalia.dev)

### ✨ Nix DevShell

Nix users can use the flake's devShell to access a development environment. Run `nix develop` in the repo root to enter the dev shell. It includes packages, utilities and environment variables needed to develop Noctalia.

---

## ⭐ Star History

<p align="center">
  <a href="https://github.com/noctalia-dev/noctalia-shell/stargazers">
    <img src="https://api.noctalia.dev/stars" alt="Star History" />
  </a>
</p>

---

## 💜 Credits

A heartfelt thank you to our incredible community of [**contributors**](https://github.com/noctalia-dev/noctalia-shell/graphs/contributors). We are immensely grateful for your dedicated participation and the constructive feedback you've provided, which continue to shape and improve our project for everyone.

---

## ☕ Donations

While all donations are greatly appreciated, they are completely voluntary.
Thank you to everyone who supports the project! 💜

<p>
  <a href="https://www.buymeacoffee.com/noctalia">
    <img src="https://img.shields.io/badge/Buy_Me_a_Coffee-A8AEFF?style=for-the-badge&logo=buymeacoffee&logoColor=FFFFFF&labelColor=0C0D11" alt="Buy Me a Coffee">
  </a>
  <a href="https://ko-fi.com/noctaliadev">
    <img src="https://img.shields.io/badge/Ko--fi-A8AEFF?style=for-the-badge&logo=kofi&logoColor=FFFFFF&labelColor=0C0D11" alt="Ko-fi">
  </a>
</p>

---

## 📄 License

MIT License - see [LICENSE](./LICENSE) for details.
