//--------------------------------------------------------------
// TwoColoursThroughTwoMasks.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( “Two Colours Through Two Masks, "Mixes", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Method", kNoGroup, 0, "Add Through Mask|Subtract Through Mask|Invert Add|Subtract Inverted" );
DeclareColourParam( FillColour, “FillColour”, kNoGroup, kNoFlags, 1,1,1,1 );
DeclareColourParam( EdgeColour, “EdgeColour”, kNoGroup, kNoFlags, 1,1,1,1 );
DeclareFloatParam( Opacity, "Opacity", kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );
DeclareFloatParam( FillOpacity, "FillOpacity", kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );
DeclareFloatParam( EdgeOpacity, "EdgeOpacity", kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );
DeclareBoolParam( HasFill, "HasFill", kNoGroup, true );
DeclareBoolParam( HasEdge, "HasEdge", kNoGroup, true );
 
//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( bg );
DeclareInput( fillMask );
DeclareInput( edgeMask );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint( AddThroughMask )
{
   float4 bgPix = ReadPixel( bg, uv1 );
   float4 fillPix = ReadPixel( fillMask, uv2 );
   float4 edgePix = ReadPixel( edgeMask, uv3 );
   float fillAlpha = 1.0f - ( FillOpacity * ( fillPix.r + fillPix.g + fillPix.b ) / 3.0 );
   float edgeAlpha = 1.0f - ( EdgeOpacity * ( edgePix.r + edgePix.g + edgePix.b ) / 3.0 );

   float4 fillToBg = bgPix;
   if( HasFill )
	 fillToBg = lerp( FillColour, bgPix, fillAlpha );
   float4 edgeToBg = fillToBg;
   if( HasEdge )
     edgeToBg = lerp( EdgeColour, fillToBg, edgeAlpha );
   float4 opacityToBg = lerp( edgeToBg, bgPix, 1.0f - Opacity );
   opacityToBg.a = bgPix.a;

   return opacityToBg;
}
//--------------------------------------------------------------
DeclareEntryPoint( SubtractThroughMask )
{
   float4 bgPix = ReadPixel( bg, uv1 );
   float4 fillPix = ReadPixel( fillMask, uv2 );
   float4 edgePix = ReadPixel( edgeMask, uv3 );
   
   float4 maskPix = fillPix;

   maskPix.r = bgPix.r - ( fillPix.r * FillOpacity) - ( edgePix.r * EdgeOpacity );
   maskPix.g = bgPix.g - ( fillPix.g * FillOpacity) - ( edgePix.g * EdgeOpacity );
   maskPix.b = bgPix.b - ( fillPix.b * FillOpacity) - ( edgePix.b * EdgeOpacity );
   if( maskPix.r < 0.0 )
      maskPix.r = 0.0;   
   if( maskPix.g < 0.0 )
      maskPix.g = 0.0;   
  if( maskPix.b < 0.0 )
      maskPix.b = 0.0;   
	
	maskPix.a = bgPix.a;

	return maskPix;
}
//--------------------------------------------------------------
DeclareEntryPoint( InvertAdd )
{
   float4 bgPix = ReadPixel( bg, uv1 );
   float4 fillPix = ReadPixel( fillMask, uv2 );
   float4 edgePix = ReadPixel( edgeMask, uv3 );

   float4 invertedPix;
   invertedPix.r = 1.0 - (( fillPix.r * FillOpacity) + ( edgePix.r * EdgeOpacity ));
   invertedPix.g = 1.0 - (( fillPix.g * FillOpacity) + ( edgePix.g * EdgeOpacity ));
   invertedPix.b = 1.0 - (( fillPix.b * FillOpacity) + ( edgePix.b * EdgeOpacity ));
   if( invertedPix.r < 0.0 )
      invertedPix.r = 0.0;   
   if( invertedPix.g < 0.0 )
      invertedPix.g = 0.0;   
   if( invertedPix.b < 0.0 )
      invertedPix.b = 0.0;     

   float4 maskPix = fillPix;
   maskPix.r = bgPix.r + invertedPix.r;
   maskPix.g = bgPix.g + invertedPix.g;
   maskPix.b = bgPix.b + invertedPix.b;
   if( maskPix.r > 1.0 )
      maskPix.r = 1.0;   
   if( maskPix.g > 1.0 )
      maskPix.g = 1.0;   
  if( maskPix.b > 1.0 )
      maskPix.b = 1.0;   

   return maskPix;
}
//--------------------------------------------------------------
DeclareEntryPoint( SubtractInverted )
{
   float4 bgPix = ReadPixel( bg, uv1 );
   float4 fillPix = ReadPixel( fillMask, uv2 );
   float4 edgePix = ReadPixel( edgeMask, uv3 );
   
   float4 maskPix = fillPix;
   
   maskPix.r = bgPix.r - ( 1.0f - (( fillPix.r * FillOpacity) - ( edgePix.r * EdgeOpacity )));
   maskPix.g = bgPix.g - ( 1.0f - (( fillPix.g * FillOpacity) - ( edgePix.g * EdgeOpacity )));
   maskPix.b = bgPix.b - ( 1.0f - (( fillPix.b * FillOpacity) - ( edgePix.b * EdgeOpacity )));
   if( maskPix.r < 0.0 )
      maskPix.r = 0.0;   
   if( maskPix.g < 0.0 )
      maskPix.g = 0.0;   
  if( maskPix.b < 0.0 )
      maskPix.b = 0.0;   

   return maskPix;
}