//--------------------------------------------------------------//
// StereoscopicAdjust.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
#include "_utils.fx"

DeclareLightworksEffect("simpleMask", "Stylize", "Internal", kNoNotes, "CanSize");

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
DeclareInput( Input );
DeclareMask;


//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
DeclareEntryPoint()
{
   float4 ret;
   if ( IsOutOfBounds( uv1 ) )
   {
      ret = kTransparentBlack;
   }
   else
   {	
      float4 source = ReadPixel(Input, uv0);
      float4 maskVal = ReadPixel(Mask, uv0);

      ret = source;
      ret.a = maskVal.r*source.a;//as the mask is in black and white, alpha not set so look at the colour r/g/b all the same, multiply by the source alpha incase we have an image with transparency
   }
   
   return ret;
}

