//--------------------------------------------------------------
// Sharpen
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Sharpen", "Stylize", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Amount, "Amount", kNoGroup, kNoFlags, 0.2, 0.0, 1.0 );

DeclareFloatParam( _OutputWidth );
DeclareFloatParam( _OutputHeight );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 ret;

   if ( IsOutOfBounds( uv1 ) )
   {
      ret = kTransparentBlack;
   }
   else
   {
      float xOffset = 1.0 / _OutputWidth;
      float yOffset = 1.0 / _OutputHeight;

      float scaledAmount = Amount * 5.0;
      float fac = scaledAmount / 8.0;

      float4 source = tex2D( Input, uv1 );
      ret = source * ( 1.0 + scaledAmount );

      ret -= tex2D( Input, uv1 + float2( -xOffset, -yOffset ) ) * fac;
      ret -= tex2D( Input, uv1 + float2( 0.0,      -yOffset ) ) * fac;
      ret -= tex2D( Input, uv1 + float2( xOffset,  -yOffset ) ) * fac;
      ret -= tex2D( Input, uv1 + float2( -xOffset, 0.0 ) )      * fac;
      ret -= tex2D( Input, uv1 + float2( xOffset,  0.0 ) )      * fac;
      ret -= tex2D( Input, uv1 + float2( -xOffset,  yOffset ) ) * fac;
      ret -= tex2D( Input, uv1 + float2( 0.0,       yOffset ) ) * fac;
      ret -= tex2D( Input, uv1 + float2( xOffset,   yOffset ) ) * fac;

      ret = lerp( source, ret, source.a );
      ret.a = source.a;
      ret = lerp( source, ret, tex2D( Mask, uv1 ));
   }

   return ret;
}
