//--------------------------------------------------------------
// segment.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( Segment, "Internal", "DVE", kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );

//--------------------------------------------------------------
// Params/Constants
//--------------------------------------------------------------
DeclareFloatParam( HueShift );
DeclareFloatParam( SatMult );
DeclareFloatParam( LumMult );
DeclareFloatParam( Contrast );

const float PI_DIV_180 = 3.14159265/180.0;
const float3x3 kRGBToYIQ = float3x3( 0.299, 0.587, 0.114, 0.596, -0.274, -0.321, 0.211, -0.523, 0.311 );
const float3x3 kYIQToRGB = float3x3( 1.0, 0.956, 0.621, 1.0, -0.272, -0.647, 1.0, -1.107, 1.705 );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 rgba = tex2D( Input, uv0 );

   // See http://beesbuzz.biz/code/hsv_color_transforms.php

   float LumSat = LumMult * SatMult;
   float HuePie = HueShift * PI_DIV_180;

   float VSU = LumSat * cos( HuePie );
   float VSW = LumSat * sin( HuePie );

   float3x3 adjustment = float3x3( LumMult, 0, 0, 0, VSU, -VSW, 0, VSW, VSU );

   rgba.rgb = mul( kYIQToRGB, mul( mul( kRGBToYIQ, rgba.rgb ), adjustment ) );
   rgba.rgb = ( ( rgba.rgb - 0.5f ) * Contrast ) + 0.5f;

   return rgba;
}
