//--------------------------------------------------------------
// Mosaic
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Mosaic", "Stylize", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Size, "Size", kNoGroup, kNoFlags, 0.01, 0.0, 1.0 );

DeclareFloatParam( _OutputAspectRatio );
DeclareFloatParam( _InputWidthNormalised );
DeclareFloatParam( _InputHeightNormalised );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 ret;

   float4 source = tex2D( Input, uv1 );

   if ( Size != 0.0 )
   {
      float xSize = Size;
      float ySize = xSize * _OutputAspectRatio;

      float x = round( ( uv1.x - ( _InputWidthNormalised / 2 ) ) / xSize ) * xSize;
      float y = round( ( uv1.y - ( _InputHeightNormalised / 2 ) ) / ySize ) * ySize;

      ret = tex2D( Input, float2( x + ( _InputWidthNormalised / 2 ), y + ( _InputHeightNormalised / 2 ) ) );

      ret = lerp( source, ret, source.a );
   }
   else
      ret = source;

   return lerp( source, ret, tex2D( Mask, uv1 ) );
}
