//--------------------------------------------------------------
// lut3d.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( LUT3D, Colour, Components, kNoNotes, CanSize );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
Declare3DInput( LUT );
DeclareMask;

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Amount, "Amount", kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );
DeclareFloatParam( _scale );
DeclareFloatParam( _offset );

//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 sourcePixel = ReadPixel( Input, uv1 );
   float4 cubedPixel = tex3D( LUT, ( sourcePixel.rgb * float3( _scale, _scale, _scale ) ) + float3( _offset, _offset, _offset ) );

   float4 ret = lerp( sourcePixel, cubedPixel, Amount );
   ret.a = sourcePixel.a;

   return lerp( sourcePixel, ret, tex2D( Mask, uv2 ) );
}
