//--------------------------------------------------------------
// Greyscale
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Greyscale", "Colour", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Red,           "Red",   "Channel Weights",   kNoFlags, 0.3,  0.0, 1.0 );
DeclareFloatParam( Green,         "Green", "Channel Weights",   kNoFlags, 0.59, 0.0, 1.0 );
DeclareFloatParam( Blue,          "Blue",  "Channel Weights",   kNoFlags, 0.11, 0.0, 1.0 );
DeclareFloatParam( RedContrast,   "Red",   "Channel Contrasts", kNoFlags, 1.0, -1.0, 4.0 );
DeclareFloatParam( GreenContrast, "Green", "Channel Contrasts", kNoFlags, 1.0, -1.0, 4.0 );
DeclareFloatParam( BlueContrast,  "Blue",  "Channel Contrasts", kNoFlags, 1.0, -1.0, 4.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float3 mult     = float3( Red, Green, Blue );
   float3 contrast = float3( RedContrast, GreenContrast, BlueContrast );
   float3 oneHalf  = float3( 0.5, 0.5, 0.5 );

   float4 source   = ReadPixel( Input, uv1 );
   float3 rgb      = source.rgb;
   float3 tmp      = ( ( ( source.rgb - oneHalf ) * contrast ) + oneHalf ) * mult;
   float  level    = tmp.r + tmp.g + tmp.b;

   float4 greyPixel = float4( level, level, level, 1.0 );

   float4 ret = lerp( source, greyPixel, source.a );
   ret.a = source.a;

   return lerp( source, ret, tex2D( Mask, uv1 ));
}
