//--------------------------------------------------------------
// Gradient Colour Effects
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Corner Gradient", "Mattes", "Components", kNoNotes, "CanSize|HasMinOutputSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------

DeclareColourParam( TLColour, "Top Left",     "Colours", kNoFlags, 1.0, 1.0, 0.0, 1.0 );
DeclareColourParam( TRColour, "Top Right",    "Colours", kNoFlags, 1.0, 0.0, 0.0, 1.0 );
DeclareColourParam( BLColour, "Bottom Left",  "Colours", kNoFlags, 0.0, 0.0, 1.0, 1.0 );
DeclareColourParam( BRColour, "Bottom Right", "Colours", kNoFlags, 0.0, 1.0, 1.0, 1.0 );
DeclareFloatParam( Left,   "Left",   "Bounds", "SpecifiesBoxL", 0.0, 0.0, 1.0 );
DeclareFloatParam( Bottom, "Bottom", "Bounds", "SpecifiesBoxB", 0.0, 0.0, 1.0 );
DeclareFloatParam( Right,  "Right",  "Bounds", "SpecifiesBoxR", 1.0, 0.0, 1.0 );
DeclareFloatParam( Top,    "Top",    "Bounds", "SpecifiesBoxT", 1.0, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 ret;
   float4 pixel = ReadPixel( Input, uv1 );

   float top = 1.0 - Top;
   float bottom = 1.0 - Bottom;

   if ( uv0.x >= Left && uv0.x <= Right && uv0.y >= top && uv0.y <= bottom )
   {
      float4 tmp1  = lerp( pixel, TLColour, TLColour.a );
      float4 tmp2  = lerp( pixel, TRColour, TRColour.a );
      float4 tmp3  = lerp( pixel, BLColour, BLColour.a );
      float4 tmp4  = lerp( pixel, BRColour, BRColour.a );

      float xAmount = ( uv0.x - Left ) / ( Right - Left );
      float yAmount = ( uv0.y - top ) / ( bottom - top );

      float4 tmp5  = lerp( tmp1, tmp2, xAmount );
      float4 tmp6  = lerp( tmp3, tmp4, xAmount );

      ret   = lerp( tmp5, tmp6, yAmount );
      ret.a = pixel.a;
   }
   else
      ret = pixel;

   return lerp( pixel, ret, tex2D( Mask, uv1 ) );
}
