//--------------------------------------------------------------//
// Gradient Colour Effects
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
#include "_utils.fx"

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "Corner Gradient";
   string Category    = "Mattes";
   bool CanSize       = true;
> = 0;

//--------------------------------------------------------------//
// Params
//--------------------------------------------------------------//

float4 TLColour
<
   string Description = "Top Left";
   bool SupportsAlpha = true;
> = { 1.0, 0.0, 0.0, 1.0 };

float4 TRColour
<
   string Description = "Top Right";
   bool SupportsAlpha = true;
> = { 1.0, 1.0, 0.0, 1.0 };

float4 BLColour
<
   string Description = "Bottom Left";
   bool SupportsAlpha = true;
> = { 0.0, 1.0, 0.0, 1.0 };

float4 BRColour
<
   string Description = "Bottom Right";
   bool SupportsAlpha = true;
> = { 1.0, 1.0, 1.0, 1.0 };

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
DeclareInput( Input, InputSampler );
DeclareInput( _mask, MaskSampler );

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
float4 ps_main( float2 xyNorm : TEXCOORD0, float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 pixel = ReadPixel( InputSampler, xy1 );
   float4 tmp1  = lerp( pixel, TLColour, TLColour.a );
   float4 tmp2  = lerp( pixel, TRColour, TRColour.a );
   float4 tmp3  = lerp( pixel, BLColour, BLColour.a );
   float4 tmp4  = lerp( pixel, BRColour, BRColour.a );
   float4 tmp5  = lerp( tmp1, tmp2, xyNorm.x );
   float4 tmp6  = lerp( tmp3, tmp4, xyNorm.x );

   float4 ret   = lerp( tmp5, tmp6, xyNorm.y );
   ret.a = pixel.a;

   return lerp( pixel, ret, tex2D( MaskSampler, xy1 ));
}

//--------------------------------------------------------------//
// Technique Section for Image Processing Effects
//--------------------------------------------------------------//
technique CornerGradient { pass Single_Pass {PixelShader = compile PROFILE ps_main(); } }
