//--------------------------------------------------------------
// Gradient Colour Effects
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( "Colour Gradient", "Matte", "Components", "Create horizontal, vertical or circular colour gradients", CanSize|HasMinOutputSize );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Type", kNoGroup, kNoFlags, "Top to bottom|Left to right|Radial" );
DeclareColourParam( ColourOne, "Colour", "Colour One", SupportsAlpha, 1.0, 0.0, 0.0, 1.0 );
DeclareFloatParam( ColourOneExtent, "Extent", "Colour One", kNoFlags, 1.0, 0.0, 1.0 );
DeclareColourParam( ColourTwo, "Colour", "Colour Two", SupportsAlpha, 1.0, 1.0, 0.0, 1.0 );
DeclareFloatParam( ColourTwoExtent, "Extent", "Colour Two", kNoFlags, 1.0, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint( TopToBottom )
{
   float progress = uv0.y;
   float4 pixel = ReadPixel( Input, uv1 );

   float colOneExtent = max( ColourOneExtent, 0.01 );
   float colTwoExtent = max( ColourTwoExtent, 0.01 );

   float colOneAmt = max( ColourOneExtent - progress, 0.0 ) / colOneExtent;
   float colTwoAmt = max( ColourTwoExtent - ( 1.0 - progress ), 0.0 ) / colTwoExtent;

   float4 ret  = ( lerp( pixel, ColourOne, ColourOne.a ) * colOneAmt ) +
                 ( lerp( pixel, ColourTwo, ColourTwo.a ) * colTwoAmt ) +
                 ( pixel * ( 1.0 - ( colOneAmt + colTwoAmt ) ) );

   ret.a = pixel.a;

   return lerp( pixel, ret, tex2D( Mask, uv1 ));
}

DeclareEntryPoint( LeftToRight )
{
   float progress = uv0.x;
   float4 pixel = ReadPixel( Input, uv1 );

   float colOneExtent = max( ColourOneExtent, 0.01 );
   float colTwoExtent = max( ColourTwoExtent, 0.01 );

   float colOneAmt = max( ColourOneExtent - progress, 0.0 ) / colOneExtent;
   float colTwoAmt = max( ColourTwoExtent - ( 1.0 - progress ), 0.0 ) / colTwoExtent;

   float4 ret  = ( lerp( pixel, ColourOne, ColourOne.a ) * colOneAmt ) +
                 ( lerp( pixel, ColourTwo, ColourTwo.a ) * colTwoAmt ) +
                 ( pixel * ( 1.0 - ( colOneAmt + colTwoAmt ) ) );

   ret.a = pixel.a;

   return lerp( pixel, ret, tex2D( Mask, uv1 ));
}

DeclareEntryPoint( Radial )
{
   float progress = abs( distance( uv0, float2( 0.5, 0.5 ) ) ) * 1.414; // Sqrt(2)
   float4 pixel = ReadPixel( Input, uv1 );

   float colOneExtent = max( ColourOneExtent, 0.01 );
   float colTwoExtent = max( ColourTwoExtent, 0.01 );

   float colOneAmt = max( ColourOneExtent - progress, 0.0 ) / colOneExtent;
   float colTwoAmt = max( ColourTwoExtent - ( 1.0 - progress ), 0.0 ) / colTwoExtent;

   float4 ret  = ( lerp( pixel, ColourOne, ColourOne.a ) * colOneAmt ) +
                 ( lerp( pixel, ColourTwo, ColourTwo.a ) * colTwoAmt ) +
                 ( pixel * ( 1.0 - ( colOneAmt + colTwoAmt ) ) );

   ret.a = pixel.a;

   return lerp( pixel, ret, tex2D( Mask, uv1 ));
}
