//--------------------------------------------------------------//
// difference.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( "Difference", "Mixes", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Amplify,   "Amplify",   kNoGroup, kNoFlags, 1,   1, 10 );
DeclareFloatParam( Threshold, "Threshold", kNoGroup, kNoFlags, 0,   0, 1 );
DeclareFloatParam( Amount,    "Amount",    kNoGroup, kNoFlags, 0.5, 0, 1 );
DeclareIntParam( SetTechnique, "View", kNoGroup, 0, "Difference|Difference over input one|Difference over input two|Mix|WipeLR|WipeTB|SideBySide|DiffOverSideBySide" );
DeclareColourParam( OverlayColour, "Overlay Colour", kNoGroup, kNoFlags, 1.0, 1.0, 1.0, 1.0 );

float4 kWhite = float4( 1,1,1,1 );
float4 kBlack = float4( 0,0,0,1 );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint( Difference )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 ret = abs( fgPix - bgPix );

   if ( ( ( ret.r + ret.g + ret.b ) * 10 ) > Threshold )
   {
      ret  = min( ret * Amplify, kWhite );
      ret.a = 1.0;
   }
   else
      ret = kBlack;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Overlay1 )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 ret = abs( fgPix - bgPix );

   if ( ( ( ret.r + ret.g + ret.b ) * 10 ) > Threshold )
   {
      ret = lerp( fgPix, OverlayColour, OverlayColour.a );
      ret.a = 1.0;
   }
   else
      ret = fgPix;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Overlay2 )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 ret = abs( fgPix - bgPix );

   if ( ( ( ret.r + ret.g + ret.b ) * 10 ) > Threshold )
   {
      ret = lerp( bgPix, OverlayColour, OverlayColour.a );
      ret.a = 1.0;
   }
   else
      ret = bgPix;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Mix )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   return lerp( fgPix, bgPix, Amount );
}
//--------------------------------------------------------------
DeclareEntryPoint( WipeLR )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 output;

   if ( uv1.x < Amount )
      output = fgPix;
   else
      output = bgPix;

   return output;
}
//--------------------------------------------------------------
DeclareEntryPoint( WipeTB )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 output;

   if ( uv1.y < Amount )
      output = fgPix;
   else
      output = bgPix;

   return output;
}
//--------------------------------------------------------------
DeclareEntryPoint( SideBySide )
{
   float4 fgPix = ReadPixel( fg, ( uv1 * 2 ) - float2( 0.0, 0.5 ) );
   float4 bgPix = ReadPixel( bg, ( uv2 * 2 ) - float2( 1.0, 0.5 ) );

   return lerp( fgPix, bgPix, step( 0.5, uv1.x ) );
}
//--------------------------------------------------------------
DeclareEntryPoint( DiffOverSideBySide )
{
   float4 fgPix  = ReadPixel( fg, ( uv1 * 2 ) - float2( 0.0, 0.5 ) );
   float4 bgPix  = ReadPixel( bg, ( uv2 * 2 ) - float2( 1.0, 0.5 ) );
   float4 bgPix2 = ReadPixel( bg, ( uv2 * 2 ) - float2( 0.0, 0.5 ) );

   float4 ret = lerp( fgPix, bgPix, step( 0.5, uv1.x ) );

   float4 diff = abs( fgPix - bgPix2 );

   if ( ( ( diff.r + diff.g + diff.b ) * 10 ) > Threshold )
   {
      ret = lerp( ret, OverlayColour, OverlayColour.a );
      ret.a = 1.0;
   }

   return ret;
}
