//--------------------------------------------------------------
// Colour finder
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Colour Mask", "Key", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareColourParam( KeyColour,     "Colour",    kNoGroup, "SpecifiesColourRange",        0.0,  0.0,  0.0,  -1 );
DeclareColourParam( Tolerance,     "Tolerance", kNoGroup, "SpecifiesColourRange|Hidden", 0.0,  0.0,  0.0,   0 );
DeclareColourParam( KeySoftAmount, "Softness",  kNoGroup, "SpecifiesColourRange|Hidden", 0.03, 0.03, 0.03, -1 );
DeclareBoolParam( Invert, "Invert", kNoGroup, false );
DeclareBoolParam( Reveal, "Reveal", kNoGroup, false );

//--------------------------------------------------------------
// Textures/samplers
//--------------------------------------------------------------
DeclareInput( fg );

//--------------------------------------------------------------
// Common
//--------------------------------------------------------------
#define HUE_IDX 0
#define SAT_IDX 1
#define VAL_IDX 2

float _oneSixth = 1.0 / 6.0;

//--------------------------------------------------------------
// matchHSV
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 tolerance2 = Tolerance + KeySoftAmount;

   float4 hsva = 0.0;
   float4 rgba = ReadPixel( fg, uv1 );

   float maxComponentVal = max( max( rgba.r, rgba.g ), rgba.b );
   float minComponentVal = min( min( rgba.r, rgba.g ), rgba.b );
   float componentRange  = maxComponentVal - minComponentVal;

   hsva[ VAL_IDX ] = maxComponentVal;
   hsva[ SAT_IDX ] = componentRange / maxComponentVal;

   if ( hsva[ SAT_IDX ] == 0 )
   {
      hsva[ HUE_IDX ] = 0;   // undefined
   }
   else
   {
      if ( rgba.r == maxComponentVal )
      {
         hsva[ HUE_IDX ] = ( rgba.g - rgba.b ) / componentRange;
      }
      else if ( rgba.g == maxComponentVal )
      {
         hsva[ HUE_IDX ] = 2 + ( ( rgba.b - rgba.r ) / componentRange );
      }
      else
      {
         hsva[ HUE_IDX ] = 4 + ( ( rgba.r - rgba.g ) / componentRange );
      }

      hsva[ HUE_IDX ] *= _oneSixth;
      if (hsva[ HUE_IDX ] < 0) hsva[ HUE_IDX ] += 1.0;
   }

   // Calc difference between current pixel and specified key-colour
   float4 diff = abs( hsva - KeyColour );

   if ( diff[ HUE_IDX ] > 0.5 )
      diff[ HUE_IDX ] = 1.0 - diff[ HUE_IDX ];

   // Now we can calculate the output value
   if ( any( saturate( diff - tolerance2 ) ) )
   {
      rgba.a = 1.0; // Too far away
   }
   else
   {
      diff = saturate( diff - Tolerance ) / KeySoftAmount;
      rgba.a = max( max( diff[ HUE_IDX ], diff[ SAT_IDX ] ), diff[ VAL_IDX ] );
   }

   rgba.a = lerp( 1.0 - rgba.a, rgba.a, Invert );

   if ( Reveal )
   {
      rgba.rgb = lerp( 0, rgba.rgb, rgba.a );
      rgba.a   = 1.0;
   }

   return rgba;
}
