DeclareLightworksEffect( "Checkerboard", "Internal", "Components", kNoNotes, kNoFlags );

//------------------------------------------------------------------------
// Inputs
//------------------------------------------------------------------------
DeclareInput( Input );

DeclareColourParam( One, "One", kNoGroup, kNoFlags, 0.25, 0.25, 0.25 );
DeclareColourParam( Two, "Two", kNoGroup, kNoFlags, 0.20, 0.20, 0.20 );
DeclareFloatParam( Size, "Size", kNoGroup, kNoFlags, 0.02, 0, 1 );
float _OutputAspectRatio = 1.0;

//------------------------------------------------------------------------
// Code
//------------------------------------------------------------------------
DeclareEntryPoint()
{
   float4 input = ReadPixel( Input, uv1 );
   float4 output = input;

   float xCount = floor( uv1.x / Size );
   float yCount = floor( uv1.y / ( Size * _OutputAspectRatio ) );
   float xRepeat = fmod( xCount, 2 );
   float yRepeat = fmod( yCount, 2 );
   
   return lerp( lerp( lerp( One, Two, xRepeat ), lerp( Two, One, xRepeat ), yRepeat ), input, input.a );
}
