//--------------------------------------------------------------
// Channel Offset
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Channel Offset", "Stylize", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( RedX,   "X", "Red",   kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( RedY,   "Y", "Red",   kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( GreenX, "X", "Green", kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( GreenY, "Y", "Green", kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( BlueX,  "X", "Blue",  kNoFlags, 0.0, -1.0, 1.0 );
DeclareFloatParam( BlueY,  "Y", "Blue",  kNoFlags, 0.0, -1.0, 1.0 );

float _maxShift = 0.1;

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 pixel  = ReadPixel( Input, uv1 );
   float4 RPixel = ReadPixel( Input, uv1 + ( float2( -RedX,   RedY )   * _maxShift ) );
   float4 GPixel = ReadPixel( Input, uv1 + ( float2( -GreenX, GreenY ) * _maxShift ) );
   float4 BPixel = ReadPixel( Input, uv1 + ( float2( -BlueX,  BlueY )  * _maxShift ) );

   return float4( RPixel.r, GPixel.g, BPixel.b, pixel.a );
}
