//--------------------------------------------------------------//
// RGB Colour Correction
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "Colour Correction";
   string Category    = "Colour Effects";
   bool CanSize       = true;
> = 0;

//--------------------------------------------------------------//
// Params
//--------------------------------------------------------------//
float4 BlackLevel
<
   string Description = "Black";
   string Group = "Balance";
> = { 0.0, 0.0, 0.0, 1.0 };

float4 WhiteLevel
<
   string Description = "White";
   string Group = "Balance";
> = { 1.0, 1.0, 1.0, 1.0 };

float4 GreyLevel
<
   string Description = "Grey";
   string Group = "Balance";
> = { 0.5, 0.5, 0.5, 1.0 };

float MasterGamma
<
   string Description = "Master";
   string Group = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float RedGamma
<
   string Description = "Red";
   string Group = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float GreenGamma
<
   string Description = "Green";
   string Group = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float BlueGamma
<
   string Description = "Blue";
   string Group = "Gamma";
   float MinVal = 0.10;
   float MaxVal = 4.00;
> = 1.00;

float MasterContrast
<
   string Description = "Master";
   string Group = "Contrast";
   float MinVal = 0.00;
   float MaxVal = 5.00;
> = 1.0;

float RedContrast
<
   string Description = "Red";
   string Group = "Contrast";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 1.0;

float GreenContrast
<
   string Description = "Green";
   string Group = "Contrast";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 1.0;

float BlueContrast
<
   string Description = "Blue";
   string Group = "Contrast";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 1.0;

float MasterBrightness
<
   string Description = "Master";
   string Group = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float RedBrightness
<
   string Description = "Red";
   string Group = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float GreenBrightness
<
   string Description = "Green";
   string Group = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float BlueBrightness
<
   string Description = "Blue";
   string Group = "Brightness";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float MasterGain
<
   string Description = "Master";
   string Group = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

float RedGain
<
   string Description = "Red";
   string Group = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

float GreenGain
<
   string Description = "Green";
   string Group = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

float BlueGain
<
   string Description = "Blue";
   string Group = "Gain";
   float MinVal = 0.00;
   float MaxVal = 4.00;
> = 1.0;

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
texture Input;

sampler InputSampler = sampler_state
{
   Texture  = <Input>;
   ADDRESSU = BORDER;
   ADDRESSV = BORDER;
};

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//

float4 ps_main( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float masterGamma    = MasterGamma - 1.0;
   float masterContrast = MasterContrast - 1.0;
   float masterGain     = MasterGain - 1.0;
   float greyAverage    = ( GreyLevel.r + GreyLevel.g + GreyLevel.b ) / 3.0;

   float4 Gamma      = { RedGamma + masterGamma, GreenGamma + masterGamma, BlueGamma + masterGamma, 1.0 };
   float4 Contrast   = { RedContrast + masterContrast, GreenContrast + masterContrast, BlueContrast + masterContrast, 1.0 };
   float4 Brightness = { RedBrightness + MasterBrightness, GreenBrightness + MasterBrightness, BlueBrightness + MasterBrightness, 1.0 };
   float4 Gain       = { RedGain + masterGain, GreenGain + masterGain, BlueGain + masterGain, 1.0 };

   float4 source = tex2D( InputSampler, xy1 );
   float  sourceAlpha  = source.a;

   source -= BlackLevel;
   source /= ( WhiteLevel - BlackLevel );
   source -= GreyLevel;
   source += greyAverage;
   source = clamp( source, 0.0, 1.0 );

   float4 ret = ( ( ( ( pow( source, 1 / Gamma ) * Gain ) + Brightness ) - 0.5 ) * Contrast ) + 0.5;

   ret = lerp( source, ret, sourceAlpha );
   ret.a = sourceAlpha;

   return ret;
}

//--------------------------------------------------------------//
// Technique Section for Image Processing Effects
//--------------------------------------------------------------//
technique Effect {pass Single_Pass { PixelShader = compile PROFILE ps_main(); } }
