//--------------------------------------------------------------
// BlendMask.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Masked Blend", "Mixes", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Method", kNoGroup, 0, "In Front|Add|Subtract|Multiply|Screen|Overlay|Soft Light|Hard Light|Exclusion|Lighten|Darken|Average|Difference|Colour|Luminosity|Dodge|Burn" );
DeclareFloatParam( Opacity, "Fg Opacity", kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( fg );
DeclareInput( bg );
DeclareInput( mask );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint( InFront )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = lerp( bgPix, fgPix, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Add )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = lerp( bgPix, clamp( fgPix + bgPix, 0.0, 1.0 ), alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Subtract )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = lerp( bgPix, clamp( fgPix - bgPix, 0.0, 1.0 ), alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Multiply )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = lerp( bgPix, bgPix * fgPix, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Screen )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = 1.0 -( ( 1.0 - fgPix ) * ( 1.0 - bgPix ) );
   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Overlay )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 result;

   if ( bgPix.r < 0.5 )
      result.r = 2.0 * fgPix.r * bgPix.r;
   else
      result.r = 1.0 - ( 2.0 * ( 1.0 - fgPix.r ) * ( 1.0 - bgPix.r ) );

   if ( bgPix.g < 0.5 )
      result.g = 2.0 * fgPix.g * bgPix.g;
   else
      result.g = 1.0 - ( 2.0 * ( 1.0 - fgPix.g ) * ( 1.0 - bgPix.g ) );

   if ( bgPix.b < 0.5 )
      result.b = 2.0 * fgPix.b * bgPix.b;
   else
      result.b = 1.0 - ( 2.0 * ( 1.0 - fgPix.b ) * ( 1.0 - bgPix.b ) );

   result.rgb = lerp( bgPix.rgb, result.rgb, alpha * Opacity );
   result.a   = 1.0;

   return result;
}
//--------------------------------------------------------------
DeclareEntryPoint( SoftLight )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = ( 1.0 - bgPix ) * ( fgPix * bgPix ) + ( bgPix * ( 1.0 - ( ( 1.0 - bgPix ) * ( 1.0 - fgPix ) ) ) );

   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Hardlight )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 result;

   if ( fgPix.r < 0.5 )
      result.r = 2.0 * fgPix.r * bgPix.r;
   else
      result.r = 1.0 - ( 2.0 * ( 1.0 - fgPix.r ) * ( 1.0 - bgPix.r ) );

   if ( fgPix.g < 0.5 )
      result.g = 2.0 * fgPix.g * bgPix.g;
   else
      result.g = 1.0 - ( 2.0 * ( 1.0 - fgPix.g ) * ( 1.0 - bgPix.g ) );

   if ( fgPix.b < 0.5 )
      result.b = 2.0 * fgPix.b * bgPix.b;
   else
      result.b = 1.0 - ( 2.0 * ( 1.0 - fgPix.b ) * ( 1.0 - bgPix.b ) );

   result.rgb = lerp( bgPix.rgb, result.rgb, alpha * Opacity );
   result.a = 1.0;

   return result;
}
//--------------------------------------------------------------
DeclareEntryPoint( Exclusion )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = fgPix + bgPix - ( 2.0 * fgPix * bgPix );
   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Lighten )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = lerp( bgPix, max( fgPix, bgPix ), alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Darken )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = min( fgPix, bgPix );
   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Average )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = ( fgPix + bgPix ) / 2.0;
   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Difference )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = abs( fgPix - bgPix );
   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
/*
//--------------------------------------------------------------//
float4 Hue_main( float2 uv1 : TEXCOORD1, float2 uv2 : TEXCOORD2, float2 uv3 : TEXCOORD3 ) : COLOR
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 ); float4 maskPix = ReadPixel( mask, uv3 );

   return fgPix;
}
//--------------------------------------------------------------//
float4 Saturation_main( float2 uv1 : TEXCOORD1, float2 uv2 : TEXCOORD2, float2 uv3 : TEXCOORD3 ) : COLOR
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 ); float4 maskPix = ReadPixel( mask, uv3 );

   return fgPix;
}
*/
//--------------------------------------------------------------
DeclareEntryPoint( Color )
{
   float4 ret;
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   // Calc source luminance but use dest colour..
   float dstY  = ( 0.257 * bgPix.r ) + ( 0.504 * bgPix.g ) + ( 0.098 * bgPix.b ) + 0.0625;
   float srcCr = ( 0.439 * fgPix.r ) - ( 0.368 * fgPix.g ) - ( 0.071 * fgPix.b ) + 0.5;
   float srcCb = ( -0.148 * fgPix.r ) -( 0.291 * fgPix.g ) + ( 0.439 * fgPix.b ) + 0.5;

   // Convert to RGB..
   float YBit = 1.164 * ( dstY - 0.0625 );
   ret.r = ( YBit + 1.596*(srcCr - 0.5) );
   ret.g = ( YBit - 0.813*(srcCr - 0.5) - 0.391*(srcCb - 0.5) );
   ret.b = ( YBit + 2.018*(srcCb - 0.5) );

   ret.rgb = lerp( bgPix.rgb, clamp( ret.rgb, 0.0, 1.0 ).rgb, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Luminosity )
{
   float4 ret;
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   // Calc source luminance but use dest colour..
   float srcY  = ( 0.257 * fgPix.r ) + ( 0.504 * fgPix.g ) + ( 0.098 * fgPix.b ) + 0.0625;
   float dstCr = ( 0.439 * bgPix.r ) - ( 0.368 * bgPix.g ) - ( 0.071 * bgPix.b ) + 0.5;
   float dstCb = ( -0.148 * bgPix.r ) -( 0.291 * bgPix.g ) + ( 0.439 * bgPix.b ) + 0.5;

   // Convert to RGB..
   float YBit = 1.164 * (srcY - 0.0625);
   ret.r = ( YBit + 1.596*(dstCr - 0.5) );
   ret.g = ( YBit - 0.813*(dstCr - 0.5) - 0.391*(dstCb - 0.5) );
   ret.b = ( YBit + 2.018*(dstCb - 0.5) );

   ret.rgb = lerp( bgPix.rgb, clamp( ret.rgb, 0.0, 1.0 ).rgb, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
//--------------------------------------------------------------
DeclareEntryPoint( Dodge )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = bgPix / ( 1.0 - fgPix );
   ret = lerp( bgPix, ret, alpha * Opacity );
   ret.a = 1.0;

   return ret;
}

//--------------------------------------------------------------
DeclareEntryPoint( Burn )
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );
   float4 maskPix = ReadPixel( mask, uv3 );
   float alpha = ( ( maskPix.r + maskPix.g + maskPix.b ) / 3.0 ) * maskPix.a;

   float4 ret = 1.0 - ( ( 1.0 - bgPix ) / fgPix );
   ret = lerp( bgPix, clamp( ret, 0.0, 1.0 ), alpha * Opacity );
   ret.a = 1.0;

   return ret;
}
