//--------------------------------------------------------------
// YCrCb444ToRGB.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( YCrCb444ToRGB, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( gSourceImage, Point );

DeclareFloat3Param( ccCoefsAdd1 );
DeclareFloat3x3Param( ccCoefsMul2 );
DeclareFloat3Param( ccCoefsAdd3 );
DeclareIntParam( includeAlpha );

//------------------------------------------------------------------------
DeclareEntryPoint()
{
   float3 yuv;
   float4 src = tex2D( gSourceImage, uv1 );
   float4 ret;

   yuv = src.gab;
   // video range Y'CbCr upto 12-bit
   ret.rgb = mul( yuv + ccCoefsAdd1, ccCoefsMul2 ) + ccCoefsAdd3;
   // full range alpha upto 16-bit
   if ( includeAlpha )
     ret.a = src.r;
   else
     ret.a = 1;

   return ret;
}
