//--------------------------------------------------------------
// TextEffects.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( TextEffects, Text, Internal, kNoNotes, CanSize );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );

DeclareColourParam( ShadowColour,  ShadowColour,   kNoGroup, kNoFlags, 0,0,0,0.7 );
DeclareColourParam( FaceColour1,   FaceColour1,    kNoGroup, kNoFlags, 1,1,1,1 );
DeclareColourParam( FaceColour2,   FaceColour2,    kNoGroup, kNoFlags, 1,1,1,1 );
DeclareFloatParam( PixelWidth,     PixelWidth,     kNoGroup, kNoFlags, 1.0, 0.0, 2.0 );
DeclareFloatParam( PixelHeight,    PixelHeight,    kNoGroup, kNoFlags, 1.0, 0.0, 2.0 );
DeclareFloatParam( ShadowSoftness, ShadowSoftness, kNoGroup, kNoFlags, 0.7, 0.0, 1.0 );
DeclareFloatParam( OutlineSize,    OutlineSize,    kNoGroup, kNoFlags, 1.0, 0.0, 2.0 );
DeclareFloatParam( Opacity,        Opacity,        kNoGroup, kNoFlags, 1.0, 0.0, 1.0 );
DeclareColourParam( OutlineColour, OutlineColour,  kNoGroup, kNoFlags, 0,0,0,1 );

float _kMidPos = 0.6;
float _MaxOutlineSize = 5.0;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint( flatColour )
{
   float4 src = tex2D( Input, uv1 );

   float4 result = FaceColour1;
   result.a = src.r * FaceColour1.a;

   return result;
}
//--------------------------------------------------------------
DeclareEntryPoint( verticalGradient )
{
   float4 src = tex2D( Input, uv1 );

   float4 result = lerp( FaceColour1, FaceColour2, ( uv1.y * 2 ) - 0.5 );
   result.a = src.r * FaceColour1.a;

   return result;
}
//--------------------------------------------------------------
DeclareEntryPoint( sheen )
{
   float4 result;
   float4 src = tex2D( Input, uv1 );

   if ( uv1.y < _kMidPos )
      result = lerp( FaceColour1, FaceColour2, ( ( uv1.y / _kMidPos ) - 0.5 ) * 2 );
   else
      result = lerp( FaceColour1, FaceColour2, ( ( ( 1 - uv1.y ) / ( 1.0 - _kMidPos ) ) - 0.5 ) * 2 );

   result.a = src.r * FaceColour1.a;

   return result;
}
//--------------------------------------------------------------
DeclareEntryPoint( shadow )
{
   float4 src = tex2D( Input, uv1 );

   float4 result = ShadowColour;
   result.a = src.r * ShadowColour.a;

   return result;
}
//--------------------------------------------------------------
float gaussian[] = { 1.0 / 4096.0, 12.0 / 4096.0, 66.0 / 4096.0, 220.0 / 4096.0, 495.0 / 4096.0, 792.0 / 4096.0, 924.0 / 4096.0 };

DeclareEntryPoint( shadowPassOne )
{
   float one   = PixelWidth * ShadowSoftness;
   float two   = one * 2;
   float halfOne  = one / 2;

   float tap1  = uv1.x + one + halfOne;
   float tap2  = tap1 + two;
   float tap3  = tap2 + two;
   float tap4  = tap3 + two;
   float tap5  = tap4 + two;
   float tap6  = tap5 + two;
   float ntap1 = uv1.x - ( one + halfOne );
   float ntap2 = ntap1 - two;
   float ntap3 = ntap2 - two;
   float ntap4 = ntap3 - two;
   float ntap5 = ntap4 - two;
   float ntap6 = ntap5 - two;

   float4 pixel = tex2D( Input, uv1 );
   float4 blurred = pixel * gaussian[ 6 ];

   blurred += tex2D( Input, float2( tap1,  uv1.y ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( tap2,  uv1.y ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( tap3,  uv1.y ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( tap4,  uv1.y ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( tap5,  uv1.y ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( tap6,  uv1.y ) ) * gaussian[ 0 ];

   blurred += tex2D( Input, float2( ntap1, uv1.y ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( ntap2, uv1.y ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( ntap3, uv1.y ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( ntap4, uv1.y ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( ntap5, uv1.y ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( ntap6, uv1.y ) ) * gaussian[ 0 ];

   return float4( blurred.r, blurred.r, blurred.r, blurred.r );
}

//--------------------------------------------------------------
DeclareEntryPoint( shadowPassTwo )
{
   float one   = PixelHeight * ShadowSoftness;
   float two   = one * 2;
   float halfOne  = one / 2;

   float tap1  = uv1.y + one + halfOne;
   float tap2  = tap1 + two;
   float tap3  = tap2 + two;
   float tap4  = tap3 + two;
   float tap5  = tap4 + two;
   float tap6  = tap5 + two;
   float ntap1 = uv1.y - ( one + halfOne );
   float ntap2 = ntap1 - two;
   float ntap3 = ntap2 - two;
   float ntap4 = ntap3 - two;
   float ntap5 = ntap4 - two;
   float ntap6 = ntap5 - two;

   float4 pixel = tex2D( Input, uv1 );
   float4 blurred = pixel * gaussian[ 6 ];

   blurred += tex2D( Input, float2( uv1.x,  tap1 ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( uv1.x,  tap2 ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( uv1.x,  tap3 ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( uv1.x,  tap4 ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( uv1.x,  tap5 ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( uv1.x,  tap6 ) ) * gaussian[ 0 ];

   blurred += tex2D( Input, float2( uv1.x, ntap1 ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( uv1.x, ntap2 ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( uv1.x, ntap3 ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( uv1.x, ntap4 ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( uv1.x, ntap5 ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( uv1.x, ntap6 ) ) * gaussian[ 0 ];

   blurred.a = blurred.a * ShadowColour.a;
   blurred.rgb = ShadowColour.rgb;

   return blurred;
}

//--------------------------------------------------------------
DeclareEntryPoint( outlinePassOne )
{
   float one   = PixelWidth * OutlineSize;
   float two   = one * 2;
   float halfOne  = one / 2;

   float tap1  = uv1.x + one + halfOne;
   float tap2  = tap1 + two;
   float tap3  = tap2 + two;
   float tap4  = tap3 + two;
   float tap5  = tap4 + two;
   float tap6  = tap5 + two;
   float ntap1 = uv1.x - ( one + halfOne );
   float ntap2 = ntap1 - two;
   float ntap3 = ntap2 - two;
   float ntap4 = ntap3 - two;
   float ntap5 = ntap4 - two;
   float ntap6 = ntap5 - two;

   float4 pixel = tex2D( Input, uv1 );
   float4 blurred = pixel * gaussian[ 6 ];

   blurred += tex2D( Input, float2( tap1,  uv1.y ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( tap2,  uv1.y ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( tap3,  uv1.y ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( tap4,  uv1.y ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( tap5,  uv1.y ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( tap6,  uv1.y ) ) * gaussian[ 0 ];

   blurred += tex2D( Input, float2( ntap1, uv1.y ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( ntap2, uv1.y ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( ntap3, uv1.y ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( ntap4, uv1.y ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( ntap5, uv1.y ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( ntap6, uv1.y ) ) * gaussian[ 0 ];

   return float4( blurred.r, blurred.r, blurred.r, blurred.r );
}

//--------------------------------------------------------------
DeclareEntryPoint( outlinePassTwo )
{
   float one   = PixelHeight * OutlineSize;
   float two   = one * 2;
   float halfOne  = one / 2;

   float tap1  = uv1.y + one + halfOne;
   float tap2  = tap1 + two;
   float tap3  = tap2 + two;
   float tap4  = tap3 + two;
   float tap5  = tap4 + two;
   float tap6  = tap5 + two;
   float ntap1 = uv1.y - ( one + halfOne );
   float ntap2 = ntap1 - two;
   float ntap3 = ntap2 - two;
   float ntap4 = ntap3 - two;
   float ntap5 = ntap4 - two;
   float ntap6 = ntap5 - two;

   float4 pixel = tex2D( Input, uv1 );
   float4 blurred = pixel * gaussian[ 6 ];

   blurred += tex2D( Input, float2( uv1.x,  tap1 ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( uv1.x,  tap2 ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( uv1.x,  tap3 ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( uv1.x,  tap4 ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( uv1.x,  tap5 ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( uv1.x,  tap6 ) ) * gaussian[ 0 ];

   blurred += tex2D( Input, float2( uv1.x, ntap1 ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( uv1.x, ntap2 ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( uv1.x, ntap3 ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( uv1.x, ntap4 ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( uv1.x, ntap5 ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( uv1.x, ntap6 ) ) * gaussian[ 0 ];

   blurred.rgb = OutlineColour.rgb;
   blurred.a = pow( blurred.a, 0.3 );
   blurred.a *= OutlineColour.a * 3;

   return blurred;
}
//--------------------------------------------------------------
DeclareEntryPoint( passThrough )
{
   float4 result = tex2D( Input, uv1 );
   result.a = result.r * FaceColour1.a;

   return result;
}

