//--------------------------------------------------------------
// RoundedRectangle.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( RoundedRectangle, "Internal", "Matte", kNoNotes, kNoFlags );

DeclareColourParam( LineColour, "Line Colour", kNoGroup, kNoFlags, 0,0,0,0 );
DeclareColourParam( FillColour, "Fill Colour", kNoGroup, kNoFlags, 0,0,0,0 );
DeclareFloatParam( Radius,    "Radius", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );
DeclareFloatParam( Softness,  "Softness", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );
DeclareFloatParam( Thickness, "Thickness", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );
DeclareFloatParam( Aspect,    "Aspect", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );

DeclareEntryPoint()
{
   uv1 = 0.5 - abs( uv1 - 0.5 );
   uv1.x *= Aspect;

   float dist = length( max( float2( 0,0 ), Radius - uv1 ) ) / Radius;

   float fillAmount = smoothstep( 1 - Softness, 1, dist );
   float lineAmount = smoothstep( 1 - ( Softness + Thickness ), 1 - Thickness, dist ) - fillAmount;

   return lerp( lerp( FillColour, 0, fillAmount ), LineColour, lineAmount * LineColour.a );
}
