//--------------------------------------------------------------//
// RGBToYCrCb422
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( RGBToYCrCb422, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( gSourceImage, Point );

DeclareFloat3x3Param( coefsMul );
DeclareFloat3Param( coefsAdd );
DeclareFloat3Param( coefsMulY );
DeclareFloatParam( coefsAddY );

#define Half_10Bit (0.5/1024.0)

//------------------------------------------------------------------------
DeclareEntryPoint()
{
   // U and V (Cr and Cb) samples are co-sited with odd-numbered Y-samples (eg, 1st, 3rd, 5th)

   float4 ret;

   float4 inDiffuse1 = tex2D( gSourceImage, uv1 );
   float4 inDiffuse2 = tex2D( gSourceImage, uv2 );

   // First pixel (provides Y, Cr and Cb samples at this position)
   ret.bag = mul( inDiffuse1.rgb, coefsMul ) + coefsAdd;

   // Second pixel (Provides Y-sample at this position only)
   ret.r = mul( inDiffuse2.rgb, coefsMulY ) + coefsAddY;

   // Rounding correction
   ret += Half_10Bit;

   return ret;
}
