//--------------------------------------------------------------//
// RGB8ToARGB
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( NULL, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 ret;

   int x = (int) fmod( uv1.x * _Width, 4 );

   // shift a quarter pixel right
   uv1.x = uv1.x + 0.25 / _Width;

   if ( x == 0 )
   {
      float4 src = tex2D( Input, uv1 );

      ret.b = src.b;
      ret.g = src.g;
      ret.r = src.r;
   }
   else if ( x == 1 )
   {
      float4 srcl = tex2D( Input, uv2 );
      float4 srcr = tex2D( Input, uv1 );

      ret.b = srcl.a;
      ret.g = srcr.b;
      ret.r = srcr.g;
   }
   else if ( x == 2 )
   {
      float4 srcl = tex2D( Input, uv2 );
      float4 srcr = tex2D( Input, uv1 );

      ret.b = srcl.r;
      ret.g = srcl.a;
      ret.r = srcr.b;
   }
   else if ( x == 3 )
   {
      float4 src = tex2D( Input, uv1 );

      ret.b = src.g;
      ret.g = src.r;
      ret.r = src.a;
   }

   ret.a = 1.;

   return ret;
}
