//--------------------------------------------------------------
// PlanarYUV16ToARGB.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( PlanarYUV16ToARGB, Internal, Colour, kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( c1, Point );
DeclareInput( c2, Point );
DeclareInput( c3, Point );

DeclareFloat3Param( ccCoefsAdd1 );
DeclareFloat3x3Param( ccCoefsMul2 );
DeclareFloat3Param( ccCoefsAdd3 );
DeclareFloatParam( Width );
DeclareFloatParam( Normalise );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   // we need to follow the surface order A16B16G16R16 LE ORDER
   // for each float pixel (x,y) we read word 1 to 4 of each plane
   int Yx = int( fmod(uv1.x * Width, 4) );
   // repeat 2 Chroma samples for each Y
   int Cx = int( fmod(uv1.x * Width / 2, 4) );

   float3 yuv;

   // we need to follow the surface order A16B16G16R16 LE ORDER
   // for each float pixel (x,y) we read word 1 to 4 of each plane
   yuv.r = tex2D(c1, uv1)[ Yx ];
   yuv.b = tex2D(c2, uv2)[ Cx ];
   yuv.g = tex2D(c3, uv3)[ Cx ];

   float4 ret;

   // normalise 10/12 bit etc.
   yuv.rgb *= Normalise;

   ret.rgb = mul(yuv + ccCoefsAdd1, ccCoefsMul2) + ccCoefsAdd3;

   ret.a = 1;

   return ret;
}
