//--------------------------------------------------------------
// Ellipse.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( Ellipse, "Internal", "Matte", kNoNotes, kNoFlags );

DeclareColourParam( LineColour, "Line Colour", kNoGroup, kNoFlags, 0,0,0,0 );
DeclareColourParam( FillColour, "Fill Colour", kNoGroup, kNoFlags, 0,0,0,0 );
DeclareFloatParam( Softness,  "Softness", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );
DeclareFloatParam( Thickness, "Thickness", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );

DeclareEntryPoint()
{
   uv1 = 2.0 * ( uv1 - 0.5 );

   float dist = length( uv1 );
   float fillAmount = smoothstep( 1 - Softness, 1, dist );
   float lineAmount = smoothstep( 1 - ( Softness + Thickness ), 1 - Thickness, dist ) - fillAmount;

   return lerp( lerp( FillColour, 0, fillAmount ), LineColour, lineAmount * LineColour.a );
}
