//-------------------------------------------------------------------------------------------------
// DVS10bit.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//-------------------------------------------------------------------------------------------------

texture gSourceImage; // The source image

sampler SourceImageSampler = 
sampler_state
{
   Texture = <gSourceImage>;
   MipFilter = POINT;
   MinFilter = POINT;
   MagFilter = POINT; //GAUSSIANQUAD; //POINT; //LINEAR;
   AddressU  = ClampToEdge;
   AddressV  = ClampToEdge;
};

float4 ps_main( float2 uv1 : TEXCOORD1, float2 uv2 : TEXCOORD2 ) : COLOR0
{
   // The source surface must be in A8R8G8B8 format, wrapping Dvs-format data.
   // The output data will be in YCrCb422 format also wrapped as 8 bit BGRA, with values normalised to the range 0.0->1.0.
   //

   // Dvs 10 bit YCrCb 4:2:2 format is packed as follows:
   //
	// SV_MODE_NBIT_10BDVS  Proprietary bit format, easy to handle in hardware
	// AAAAAAAA BBBBBBBB CCCCCCCC 00AABBCC  ...
	// 98765432 98765432 98765432 --101010  ...

   // DWORD offset  |-0----------------------1--------------------|
   // Byte Offset   | 0     1     2     3    4     5     6     7  |
   // Value         | Y0    Cb0   Y1    z    Cr0   Y2    Cb2   z  | z = Packed low-order 2 bits of preceeding pixels

   // TEXCOORD0: y = output row 0.0->1.0 format. x = output column, 0 - ( SourceImageWidth - 1 ) format.

   // convert to 1/360ths
   float outpixPos = uv1.x * 360.;

   // remainder after divide by 3
   float rem = fmod( outpixPos, 3.0 );

   int iRem = round( rem );


   float4 outpix;

   if ( iRem == 0 )
   {
      float4 inpix1 = tex2D( SourceImageSampler, uv1 );
      float4 inpix2 = tex2D( SourceImageSampler, uv2 );

      outpix.bgr  = inpix1.bgr;
      outpix.a    = inpix2.b;
   }
   else if ( iRem == 1 )
   {
      float4 inpix1 = tex2D( SourceImageSampler, uv1 );
      float4 inpix2 = tex2D( SourceImageSampler, uv2 );

      outpix.bg   = inpix1.gr;
      outpix.ra   = inpix2.bg;
   }
   else if ( iRem == 2 )
   {
      float inpixPos  = (uv1.x- 1.0/480.) * 255. ;
      uv1.x = inpixPos / 255.;
      uv2.x = uv1.x + 1.0/360.0;

      float4 inpix1 = tex2D( SourceImageSampler, uv1 );
      float4 inpix2 = tex2D( SourceImageSampler, uv2 );

      outpix.b    = inpix1.r;
      outpix.gra  = inpix2.bgr;
   }
   else
   {
      outpix.bgr = uv1.x;
      outpix.a = 170./255.0;
   }

   return outpix;

};

technique T1 { pass P1 { PixelShader = compile PROFILE ps_main(); } }
