//--------------------------------------------------------------
// ColourBars
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( ColourBars, Internal, Colour, kNoNotes, kNoFlags );

// Colour Y Value Cr Value Cb Value
// White 235 (EB)    128 (80) 128 (80)
// Black 16 (10)     128 (80) 128 (80)
// Red 81 (51)       240 (F0) 90  (5A)
// Green 145 (91)    34 (22)  54  (36)
// Blue 41 (29)      110 (6E) 240 (F0)
// Yellow 210 (D2)   146 (92) 16  (10)
// Cyan 170 (AA)     16 (10)  166 (A6)
// Magenta 106 (6A)  222 (DE) 202 (CA)
//                   Y1             Cr                Y2                Cb
float4 White   = { 235 / 256.0,     0.5,              235.0 / 256.0,    0.5            };
float4 Black   = { 16  / 256.0,     0.5,              16 / 256.0,       0.5            };
float4 Red     = { 81  / 256.0,     240 / 256.0,      81 / 256.0,       90 / 256.0     };
float4 Green   = { 145 / 256.0,     34  / 256.0,      145 / 256.0,      54  / 256.0    };
float4 Blue    = { 41  / 256.0,     110 / 256.0,      41  / 256.0,      240 / 256.0    };
float4 Yellow  = { 210 / 256.0,     146 / 256.0,      210 / 256.0,      16  / 256.0    };
float4 Cyan    = { 170 / 256.0,     16  / 256.0,      170 / 256.0,      166 / 256.0    };
float4 Magenta = { 106 / 256.0,     222 / 256.0,      106 / 256.0,      202 / 256.0    };

DeclareEntryPoint()
{
   float4 ret;

   //int pix = (int) fmod( xy.x * _Width, _Width / 8 );
   int colour = (int) ( uv1.x * 8 );

   if ( colour == 0 )
      ret = White;
   else if ( colour == 1 )
      ret = Black;
   else if ( colour == 2 )
      ret = Red;
   else if ( colour == 3 )
      ret = Green;
   else if ( colour == 4 )
      ret = Blue;
   else if ( colour == 5 )
      ret = Yellow;
   else if ( colour == 6 )
      ret = Cyan;
   else if ( colour == 7 )
      ret = Magenta;

   return ret;
}
