//--------------------------------------------------------------
// TextEffects.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
int _LwksEffectInfo
<
   string EffectGroup = "Internal";
   bool CanSize       = true;
> = 0;

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
texture Input;

sampler LinearSampler = sampler_state
{
   Texture = <Input>;
   MINFILTER = LINEAR;
   MAGFILTER = LINEAR;
};

float4 FaceColour1 = float4( 1,1,1,1 );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
float4 clearTypeBlend( float2 xy1 : TEXCOORD1 ) : COLOR
{
   float4 src = tex2D( LinearSampler, xy1 );

   float4 output = FaceColour1;
   output.a = ( ( src.r + src.g + src.b ) / 3.0 ) * FaceColour1.a;

   return output;
}


//--------------------------------------------------------------
// Technique Section for Image Processing Effects
//--------------------------------------------------------------
technique ClearTypeBlend { pass p1 { PixelShader = compile PROFILE clearTypeBlend(); } }

